package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ApplicationSettingsResource(
    applicationId: __string,
    campaignHook: Option[zio.aws.pinpoint.model.CampaignHook] = None,
    lastModifiedDate: Option[__string] = None,
    limits: Option[zio.aws.pinpoint.model.CampaignLimits] = None,
    quietTime: Option[zio.aws.pinpoint.model.QuietTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ApplicationSettingsResource = {
    import ApplicationSettingsResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ApplicationSettingsResource
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .optionallyWith(campaignHook.map(value => value.buildAwsValue()))(
        _.campaignHook
      )
      .optionallyWith(
        lastModifiedDate.map(value => __string.unwrap(value): java.lang.String)
      )(_.lastModifiedDate)
      .optionallyWith(limits.map(value => value.buildAwsValue()))(_.limits)
      .optionallyWith(quietTime.map(value => value.buildAwsValue()))(
        _.quietTime
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ApplicationSettingsResource.ReadOnly =
    zio.aws.pinpoint.model.ApplicationSettingsResource.wrap(buildAwsValue())
}
object ApplicationSettingsResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ApplicationSettingsResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ApplicationSettingsResource =
      zio.aws.pinpoint.model.ApplicationSettingsResource(
        applicationId,
        campaignHook.map(value => value.asEditable),
        lastModifiedDate.map(value => value),
        limits.map(value => value.asEditable),
        quietTime.map(value => value.asEditable)
      )
    def applicationId: __string
    def campaignHook: Option[zio.aws.pinpoint.model.CampaignHook.ReadOnly]
    def lastModifiedDate: Option[__string]
    def limits: Option[zio.aws.pinpoint.model.CampaignLimits.ReadOnly]
    def quietTime: Option[zio.aws.pinpoint.model.QuietTime.ReadOnly]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getCampaignHook
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignHook.ReadOnly] =
      AwsError.unwrapOptionField("campaignHook", campaignHook)
    def getLastModifiedDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLimits
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignLimits.ReadOnly] =
      AwsError.unwrapOptionField("limits", limits)
    def getQuietTime
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.QuietTime.ReadOnly] =
      AwsError.unwrapOptionField("quietTime", quietTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ApplicationSettingsResource
  ) extends zio.aws.pinpoint.model.ApplicationSettingsResource.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val campaignHook
        : Option[zio.aws.pinpoint.model.CampaignHook.ReadOnly] = scala
      .Option(impl.campaignHook())
      .map(value => zio.aws.pinpoint.model.CampaignHook.wrap(value))
    override val lastModifiedDate: Option[__string] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val limits
        : Option[zio.aws.pinpoint.model.CampaignLimits.ReadOnly] = scala
      .Option(impl.limits())
      .map(value => zio.aws.pinpoint.model.CampaignLimits.wrap(value))
    override val quietTime: Option[zio.aws.pinpoint.model.QuietTime.ReadOnly] =
      scala
        .Option(impl.quietTime())
        .map(value => zio.aws.pinpoint.model.QuietTime.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ApplicationSettingsResource
  ): zio.aws.pinpoint.model.ApplicationSettingsResource.ReadOnly = new Wrapper(
    impl
  )
}
