package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ApplicationsResponse(
    item: Option[Iterable[zio.aws.pinpoint.model.ApplicationResponse]] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ApplicationsResponse = {
    import ApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ApplicationsResponse
      .builder()
      .optionallyWith(
        item.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.item)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ApplicationsResponse.ReadOnly =
    zio.aws.pinpoint.model.ApplicationsResponse.wrap(buildAwsValue())
}
object ApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ApplicationsResponse =
      zio.aws.pinpoint.model.ApplicationsResponse(
        item.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def item: Option[List[zio.aws.pinpoint.model.ApplicationResponse.ReadOnly]]
    def nextToken: Option[__string]
    def getItem: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.ApplicationResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("item", item)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ApplicationsResponse
  ) extends zio.aws.pinpoint.model.ApplicationsResponse.ReadOnly {
    override val item
        : Option[List[zio.aws.pinpoint.model.ApplicationResponse.ReadOnly]] =
      scala
        .Option(impl.item())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.ApplicationResponse.wrap(item)
          }.toList
        )
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ApplicationsResponse
  ): zio.aws.pinpoint.model.ApplicationsResponse.ReadOnly = new Wrapper(impl)
}
