package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class AttributeDimension(
    attributeType: Option[zio.aws.pinpoint.model.AttributeType] = None,
    values: Iterable[__string]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.AttributeDimension = {
    import AttributeDimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.AttributeDimension
      .builder()
      .optionallyWith(attributeType.map(value => value.unwrap))(_.attributeType)
      .values(values.map { item =>
        __string.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.AttributeDimension.ReadOnly =
    zio.aws.pinpoint.model.AttributeDimension.wrap(buildAwsValue())
}
object AttributeDimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.AttributeDimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.AttributeDimension =
      zio.aws.pinpoint.model
        .AttributeDimension(attributeType.map(value => value), values)
    def attributeType: Option[zio.aws.pinpoint.model.AttributeType]
    def values: List[__string]
    def getAttributeType
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.AttributeType] =
      AwsError.unwrapOptionField("attributeType", attributeType)
    def getValues: ZIO[Any, Nothing, List[__string]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.AttributeDimension
  ) extends zio.aws.pinpoint.model.AttributeDimension.ReadOnly {
    override val attributeType: Option[zio.aws.pinpoint.model.AttributeType] =
      scala
        .Option(impl.attributeType())
        .map(value => zio.aws.pinpoint.model.AttributeType.wrap(value))
    override val values: List[__string] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.pinpoint.model.primitives.__string(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.AttributeDimension
  ): zio.aws.pinpoint.model.AttributeDimension.ReadOnly = new Wrapper(impl)
}
