package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class AttributesResource(
    applicationId: __string,
    attributeType: __string,
    attributes: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.AttributesResource = {
    import AttributesResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.AttributesResource
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .attributeType(__string.unwrap(attributeType): java.lang.String)
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.AttributesResource.ReadOnly =
    zio.aws.pinpoint.model.AttributesResource.wrap(buildAwsValue())
}
object AttributesResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.AttributesResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.AttributesResource =
      zio.aws.pinpoint.model.AttributesResource(
        applicationId,
        attributeType,
        attributes.map(value => value)
      )
    def applicationId: __string
    def attributeType: __string
    def attributes: Option[List[__string]]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getAttributeType: ZIO[Any, Nothing, __string] =
      ZIO.succeed(attributeType)
    def getAttributes: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.AttributesResource
  ) extends zio.aws.pinpoint.model.AttributesResource.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val attributeType: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.attributeType())
    override val attributes: Option[List[__string]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpoint.model.primitives.__string(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.AttributesResource
  ): zio.aws.pinpoint.model.AttributesResource.ReadOnly = new Wrapper(impl)
}
