package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__boolean, __string}
import scala.jdk.CollectionConverters.*
final case class BaiduChannelRequest(
    apiKey: __string,
    enabled: Option[__boolean] = None,
    secretKey: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.BaiduChannelRequest = {
    import BaiduChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.BaiduChannelRequest
      .builder()
      .apiKey(__string.unwrap(apiKey): java.lang.String)
      .optionallyWith(
        enabled.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .secretKey(__string.unwrap(secretKey): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.BaiduChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.BaiduChannelRequest.wrap(buildAwsValue())
}
object BaiduChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.BaiduChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.BaiduChannelRequest =
      zio.aws.pinpoint.model
        .BaiduChannelRequest(apiKey, enabled.map(value => value), secretKey)
    def apiKey: __string
    def enabled: Option[__boolean]
    def secretKey: __string
    def getApiKey: ZIO[Any, Nothing, __string] = ZIO.succeed(apiKey)
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getSecretKey: ZIO[Any, Nothing, __string] = ZIO.succeed(secretKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.BaiduChannelRequest
  ) extends zio.aws.pinpoint.model.BaiduChannelRequest.ReadOnly {
    override val apiKey: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.apiKey())
    override val enabled: Option[__boolean] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val secretKey: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.secretKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.BaiduChannelRequest
  ): zio.aws.pinpoint.model.BaiduChannelRequest.ReadOnly = new Wrapper(impl)
}
