package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CampaignCustomMessage(data: Option[__string] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CampaignCustomMessage = {
    import CampaignCustomMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CampaignCustomMessage
      .builder()
      .optionallyWith(
        data.map(value => __string.unwrap(value): java.lang.String)
      )(_.data)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CampaignCustomMessage.ReadOnly =
    zio.aws.pinpoint.model.CampaignCustomMessage.wrap(buildAwsValue())
}
object CampaignCustomMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CampaignCustomMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CampaignCustomMessage =
      zio.aws.pinpoint.model.CampaignCustomMessage(data.map(value => value))
    def data: Option[__string]
    def getData: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("data", data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignCustomMessage
  ) extends zio.aws.pinpoint.model.CampaignCustomMessage.ReadOnly {
    override val data: Option[__string] = scala
      .Option(impl.data())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignCustomMessage
  ): zio.aws.pinpoint.model.CampaignCustomMessage.ReadOnly = new Wrapper(impl)
}
