package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CampaignEmailMessage(
    body: Option[__string] = None,
    fromAddress: Option[__string] = None,
    htmlBody: Option[__string] = None,
    title: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CampaignEmailMessage = {
    import CampaignEmailMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CampaignEmailMessage
      .builder()
      .optionallyWith(
        body.map(value => __string.unwrap(value): java.lang.String)
      )(_.body)
      .optionallyWith(
        fromAddress.map(value => __string.unwrap(value): java.lang.String)
      )(_.fromAddress)
      .optionallyWith(
        htmlBody.map(value => __string.unwrap(value): java.lang.String)
      )(_.htmlBody)
      .optionallyWith(
        title.map(value => __string.unwrap(value): java.lang.String)
      )(_.title)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CampaignEmailMessage.ReadOnly =
    zio.aws.pinpoint.model.CampaignEmailMessage.wrap(buildAwsValue())
}
object CampaignEmailMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CampaignEmailMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CampaignEmailMessage =
      zio.aws.pinpoint.model.CampaignEmailMessage(
        body.map(value => value),
        fromAddress.map(value => value),
        htmlBody.map(value => value),
        title.map(value => value)
      )
    def body: Option[__string]
    def fromAddress: Option[__string]
    def htmlBody: Option[__string]
    def title: Option[__string]
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getFromAddress: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("fromAddress", fromAddress)
    def getHtmlBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("htmlBody", htmlBody)
    def getTitle: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("title", title)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignEmailMessage
  ) extends zio.aws.pinpoint.model.CampaignEmailMessage.ReadOnly {
    override val body: Option[__string] = scala
      .Option(impl.body())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val fromAddress: Option[__string] = scala
      .Option(impl.fromAddress())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val htmlBody: Option[__string] = scala
      .Option(impl.htmlBody())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val title: Option[__string] = scala
      .Option(impl.title())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignEmailMessage
  ): zio.aws.pinpoint.model.CampaignEmailMessage.ReadOnly = new Wrapper(impl)
}
