package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CampaignHook(
    lambdaFunctionName: Option[__string] = None,
    mode: Option[zio.aws.pinpoint.model.Mode] = None,
    webUrl: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CampaignHook = {
    import CampaignHook.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CampaignHook
      .builder()
      .optionallyWith(
        lambdaFunctionName.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.lambdaFunctionName)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(
        webUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.webUrl)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CampaignHook.ReadOnly =
    zio.aws.pinpoint.model.CampaignHook.wrap(buildAwsValue())
}
object CampaignHook {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CampaignHook
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CampaignHook =
      zio.aws.pinpoint.model.CampaignHook(
        lambdaFunctionName.map(value => value),
        mode.map(value => value),
        webUrl.map(value => value)
      )
    def lambdaFunctionName: Option[__string]
    def mode: Option[zio.aws.pinpoint.model.Mode]
    def webUrl: Option[__string]
    def getLambdaFunctionName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lambdaFunctionName", lambdaFunctionName)
    def getMode: ZIO[Any, AwsError, zio.aws.pinpoint.model.Mode] =
      AwsError.unwrapOptionField("mode", mode)
    def getWebUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("webUrl", webUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignHook
  ) extends zio.aws.pinpoint.model.CampaignHook.ReadOnly {
    override val lambdaFunctionName: Option[__string] = scala
      .Option(impl.lambdaFunctionName())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val mode: Option[zio.aws.pinpoint.model.Mode] = scala
      .Option(impl.mode())
      .map(value => zio.aws.pinpoint.model.Mode.wrap(value))
    override val webUrl: Option[__string] = scala
      .Option(impl.webUrl())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignHook
  ): zio.aws.pinpoint.model.CampaignHook.ReadOnly = new Wrapper(impl)
}
