package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CampaignInAppMessage(
    body: Option[__string] = None,
    content: Option[Iterable[zio.aws.pinpoint.model.InAppMessageContent]] =
      None,
    customConfig: Option[Map[__string, __string]] = None,
    layout: Option[zio.aws.pinpoint.model.Layout] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CampaignInAppMessage = {
    import CampaignInAppMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CampaignInAppMessage
      .builder()
      .optionallyWith(
        body.map(value => __string.unwrap(value): java.lang.String)
      )(_.body)
      .optionallyWith(
        content.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.content)
      .optionallyWith(
        customConfig.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.customConfig)
      .optionallyWith(layout.map(value => value.unwrap))(_.layout)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CampaignInAppMessage.ReadOnly =
    zio.aws.pinpoint.model.CampaignInAppMessage.wrap(buildAwsValue())
}
object CampaignInAppMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CampaignInAppMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CampaignInAppMessage =
      zio.aws.pinpoint.model.CampaignInAppMessage(
        body.map(value => value),
        content.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customConfig.map(value => value),
        layout.map(value => value)
      )
    def body: Option[__string]
    def content
        : Option[List[zio.aws.pinpoint.model.InAppMessageContent.ReadOnly]]
    def customConfig: Option[Map[__string, __string]]
    def layout: Option[zio.aws.pinpoint.model.Layout]
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getContent: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.InAppMessageContent.ReadOnly
    ]] = AwsError.unwrapOptionField("content", content)
    def getCustomConfig: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("customConfig", customConfig)
    def getLayout: ZIO[Any, AwsError, zio.aws.pinpoint.model.Layout] =
      AwsError.unwrapOptionField("layout", layout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignInAppMessage
  ) extends zio.aws.pinpoint.model.CampaignInAppMessage.ReadOnly {
    override val body: Option[__string] = scala
      .Option(impl.body())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val content
        : Option[List[zio.aws.pinpoint.model.InAppMessageContent.ReadOnly]] =
      scala
        .Option(impl.content())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.InAppMessageContent.wrap(item)
          }.toList
        )
    override val customConfig: Option[Map[__string, __string]] = scala
      .Option(impl.customConfig())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val layout: Option[zio.aws.pinpoint.model.Layout] = scala
      .Option(impl.layout())
      .map(value => zio.aws.pinpoint.model.Layout.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignInAppMessage
  ): zio.aws.pinpoint.model.CampaignInAppMessage.ReadOnly = new Wrapper(impl)
}
