package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__integer
import scala.jdk.CollectionConverters.*
final case class CampaignLimits(
    daily: Option[__integer] = None,
    maximumDuration: Option[__integer] = None,
    messagesPerSecond: Option[__integer] = None,
    total: Option[__integer] = None,
    session: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CampaignLimits = {
    import CampaignLimits.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CampaignLimits
      .builder()
      .optionallyWith(daily.map(value => __integer.unwrap(value): Integer))(
        _.daily
      )
      .optionallyWith(
        maximumDuration.map(value => __integer.unwrap(value): Integer)
      )(_.maximumDuration)
      .optionallyWith(
        messagesPerSecond.map(value => __integer.unwrap(value): Integer)
      )(_.messagesPerSecond)
      .optionallyWith(total.map(value => __integer.unwrap(value): Integer))(
        _.total
      )
      .optionallyWith(session.map(value => __integer.unwrap(value): Integer))(
        _.session
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CampaignLimits.ReadOnly =
    zio.aws.pinpoint.model.CampaignLimits.wrap(buildAwsValue())
}
object CampaignLimits {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CampaignLimits
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CampaignLimits =
      zio.aws.pinpoint.model.CampaignLimits(
        daily.map(value => value),
        maximumDuration.map(value => value),
        messagesPerSecond.map(value => value),
        total.map(value => value),
        session.map(value => value)
      )
    def daily: Option[__integer]
    def maximumDuration: Option[__integer]
    def messagesPerSecond: Option[__integer]
    def total: Option[__integer]
    def session: Option[__integer]
    def getDaily: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("daily", daily)
    def getMaximumDuration: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maximumDuration", maximumDuration)
    def getMessagesPerSecond: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("messagesPerSecond", messagesPerSecond)
    def getTotal: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("total", total)
    def getSession: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("session", session)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignLimits
  ) extends zio.aws.pinpoint.model.CampaignLimits.ReadOnly {
    override val daily: Option[__integer] = scala
      .Option(impl.daily())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val maximumDuration: Option[__integer] = scala
      .Option(impl.maximumDuration())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val messagesPerSecond: Option[__integer] = scala
      .Option(impl.messagesPerSecond())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val total: Option[__integer] = scala
      .Option(impl.total())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val session: Option[__integer] = scala
      .Option(impl.session())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignLimits
  ): zio.aws.pinpoint.model.CampaignLimits.ReadOnly = new Wrapper(impl)
}
