package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__boolean, __integer, __string}
import scala.jdk.CollectionConverters.*
final case class CampaignResponse(
    additionalTreatments: Option[
      Iterable[zio.aws.pinpoint.model.TreatmentResource]
    ] = None,
    applicationId: __string,
    arn: __string,
    creationDate: __string,
    customDeliveryConfiguration: Option[
      zio.aws.pinpoint.model.CustomDeliveryConfiguration
    ] = None,
    defaultState: Option[zio.aws.pinpoint.model.CampaignState] = None,
    description: Option[__string] = None,
    holdoutPercent: Option[__integer] = None,
    hook: Option[zio.aws.pinpoint.model.CampaignHook] = None,
    id: __string,
    isPaused: Option[__boolean] = None,
    lastModifiedDate: __string,
    limits: Option[zio.aws.pinpoint.model.CampaignLimits] = None,
    messageConfiguration: Option[zio.aws.pinpoint.model.MessageConfiguration] =
      None,
    name: Option[__string] = None,
    schedule: Option[zio.aws.pinpoint.model.Schedule] = None,
    segmentId: __string,
    segmentVersion: __integer,
    state: Option[zio.aws.pinpoint.model.CampaignState] = None,
    tags: Option[Map[__string, __string]] = None,
    templateConfiguration: Option[
      zio.aws.pinpoint.model.TemplateConfiguration
    ] = None,
    treatmentDescription: Option[__string] = None,
    treatmentName: Option[__string] = None,
    version: Option[__integer] = None,
    priority: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CampaignResponse = {
    import CampaignResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CampaignResponse
      .builder()
      .optionallyWith(
        additionalTreatments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalTreatments)
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .arn(__string.unwrap(arn): java.lang.String)
      .creationDate(__string.unwrap(creationDate): java.lang.String)
      .optionallyWith(
        customDeliveryConfiguration.map(value => value.buildAwsValue())
      )(_.customDeliveryConfiguration)
      .optionallyWith(defaultState.map(value => value.buildAwsValue()))(
        _.defaultState
      )
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        holdoutPercent.map(value => __integer.unwrap(value): Integer)
      )(_.holdoutPercent)
      .optionallyWith(hook.map(value => value.buildAwsValue()))(_.hook)
      .id(__string.unwrap(id): java.lang.String)
      .optionallyWith(
        isPaused.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.isPaused)
      .lastModifiedDate(__string.unwrap(lastModifiedDate): java.lang.String)
      .optionallyWith(limits.map(value => value.buildAwsValue()))(_.limits)
      .optionallyWith(messageConfiguration.map(value => value.buildAwsValue()))(
        _.messageConfiguration
      )
      .optionallyWith(
        name.map(value => __string.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .segmentId(__string.unwrap(segmentId): java.lang.String)
      .segmentVersion(__integer.unwrap(segmentVersion): Integer)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateConfiguration.map(value => value.buildAwsValue())
      )(_.templateConfiguration)
      .optionallyWith(
        treatmentDescription.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.treatmentDescription)
      .optionallyWith(
        treatmentName.map(value => __string.unwrap(value): java.lang.String)
      )(_.treatmentName)
      .optionallyWith(version.map(value => __integer.unwrap(value): Integer))(
        _.version
      )
      .optionallyWith(priority.map(value => __integer.unwrap(value): Integer))(
        _.priority
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CampaignResponse.ReadOnly =
    zio.aws.pinpoint.model.CampaignResponse.wrap(buildAwsValue())
}
object CampaignResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CampaignResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CampaignResponse =
      zio.aws.pinpoint.model.CampaignResponse(
        additionalTreatments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applicationId,
        arn,
        creationDate,
        customDeliveryConfiguration.map(value => value.asEditable),
        defaultState.map(value => value.asEditable),
        description.map(value => value),
        holdoutPercent.map(value => value),
        hook.map(value => value.asEditable),
        id,
        isPaused.map(value => value),
        lastModifiedDate,
        limits.map(value => value.asEditable),
        messageConfiguration.map(value => value.asEditable),
        name.map(value => value),
        schedule.map(value => value.asEditable),
        segmentId,
        segmentVersion,
        state.map(value => value.asEditable),
        tags.map(value => value),
        templateConfiguration.map(value => value.asEditable),
        treatmentDescription.map(value => value),
        treatmentName.map(value => value),
        version.map(value => value),
        priority.map(value => value)
      )
    def additionalTreatments
        : Option[List[zio.aws.pinpoint.model.TreatmentResource.ReadOnly]]
    def applicationId: __string
    def arn: __string
    def creationDate: __string
    def customDeliveryConfiguration
        : Option[zio.aws.pinpoint.model.CustomDeliveryConfiguration.ReadOnly]
    def defaultState: Option[zio.aws.pinpoint.model.CampaignState.ReadOnly]
    def description: Option[__string]
    def holdoutPercent: Option[__integer]
    def hook: Option[zio.aws.pinpoint.model.CampaignHook.ReadOnly]
    def id: __string
    def isPaused: Option[__boolean]
    def lastModifiedDate: __string
    def limits: Option[zio.aws.pinpoint.model.CampaignLimits.ReadOnly]
    def messageConfiguration
        : Option[zio.aws.pinpoint.model.MessageConfiguration.ReadOnly]
    def name: Option[__string]
    def schedule: Option[zio.aws.pinpoint.model.Schedule.ReadOnly]
    def segmentId: __string
    def segmentVersion: __integer
    def state: Option[zio.aws.pinpoint.model.CampaignState.ReadOnly]
    def tags: Option[Map[__string, __string]]
    def templateConfiguration
        : Option[zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly]
    def treatmentDescription: Option[__string]
    def treatmentName: Option[__string]
    def version: Option[__integer]
    def priority: Option[__integer]
    def getAdditionalTreatments: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.TreatmentResource.ReadOnly
    ]] =
      AwsError.unwrapOptionField("additionalTreatments", additionalTreatments)
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getArn: ZIO[Any, Nothing, __string] = ZIO.succeed(arn)
    def getCreationDate: ZIO[Any, Nothing, __string] = ZIO.succeed(creationDate)
    def getCustomDeliveryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.CustomDeliveryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customDeliveryConfiguration",
      customDeliveryConfiguration
    )
    def getDefaultState
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignState.ReadOnly] =
      AwsError.unwrapOptionField("defaultState", defaultState)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getHoldoutPercent: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("holdoutPercent", holdoutPercent)
    def getHook
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignHook.ReadOnly] =
      AwsError.unwrapOptionField("hook", hook)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getIsPaused: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("isPaused", isPaused)
    def getLastModifiedDate: ZIO[Any, Nothing, __string] =
      ZIO.succeed(lastModifiedDate)
    def getLimits
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignLimits.ReadOnly] =
      AwsError.unwrapOptionField("limits", limits)
    def getMessageConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.MessageConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("messageConfiguration", messageConfiguration)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Schedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getSegmentId: ZIO[Any, Nothing, __string] = ZIO.succeed(segmentId)
    def getSegmentVersion: ZIO[Any, Nothing, __integer] =
      ZIO.succeed(segmentVersion)
    def getState
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignState.ReadOnly] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("templateConfiguration", templateConfiguration)
    def getTreatmentDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("treatmentDescription", treatmentDescription)
    def getTreatmentName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("treatmentName", treatmentName)
    def getVersion: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("version", version)
    def getPriority: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("priority", priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignResponse
  ) extends zio.aws.pinpoint.model.CampaignResponse.ReadOnly {
    override val additionalTreatments
        : Option[List[zio.aws.pinpoint.model.TreatmentResource.ReadOnly]] =
      scala
        .Option(impl.additionalTreatments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.TreatmentResource.wrap(item)
          }.toList
        )
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val arn: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.arn())
    override val creationDate: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.creationDate())
    override val customDeliveryConfiguration
        : Option[zio.aws.pinpoint.model.CustomDeliveryConfiguration.ReadOnly] =
      scala
        .Option(impl.customDeliveryConfiguration())
        .map(value =>
          zio.aws.pinpoint.model.CustomDeliveryConfiguration.wrap(value)
        )
    override val defaultState
        : Option[zio.aws.pinpoint.model.CampaignState.ReadOnly] = scala
      .Option(impl.defaultState())
      .map(value => zio.aws.pinpoint.model.CampaignState.wrap(value))
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val holdoutPercent: Option[__integer] = scala
      .Option(impl.holdoutPercent())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val hook: Option[zio.aws.pinpoint.model.CampaignHook.ReadOnly] =
      scala
        .Option(impl.hook())
        .map(value => zio.aws.pinpoint.model.CampaignHook.wrap(value))
    override val id: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.id())
    override val isPaused: Option[__boolean] = scala
      .Option(impl.isPaused())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val lastModifiedDate: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.lastModifiedDate())
    override val limits
        : Option[zio.aws.pinpoint.model.CampaignLimits.ReadOnly] = scala
      .Option(impl.limits())
      .map(value => zio.aws.pinpoint.model.CampaignLimits.wrap(value))
    override val messageConfiguration
        : Option[zio.aws.pinpoint.model.MessageConfiguration.ReadOnly] = scala
      .Option(impl.messageConfiguration())
      .map(value => zio.aws.pinpoint.model.MessageConfiguration.wrap(value))
    override val name: Option[__string] = scala
      .Option(impl.name())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val schedule: Option[zio.aws.pinpoint.model.Schedule.ReadOnly] =
      scala
        .Option(impl.schedule())
        .map(value => zio.aws.pinpoint.model.Schedule.wrap(value))
    override val segmentId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.segmentId())
    override val segmentVersion: __integer =
      zio.aws.pinpoint.model.primitives.__integer(impl.segmentVersion())
    override val state: Option[zio.aws.pinpoint.model.CampaignState.ReadOnly] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.pinpoint.model.CampaignState.wrap(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val templateConfiguration
        : Option[zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly] = scala
      .Option(impl.templateConfiguration())
      .map(value => zio.aws.pinpoint.model.TemplateConfiguration.wrap(value))
    override val treatmentDescription: Option[__string] = scala
      .Option(impl.treatmentDescription())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val treatmentName: Option[__string] = scala
      .Option(impl.treatmentName())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val version: Option[__integer] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val priority: Option[__integer] = scala
      .Option(impl.priority())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignResponse
  ): zio.aws.pinpoint.model.CampaignResponse.ReadOnly = new Wrapper(impl)
}
