package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CampaignSmsMessage(
    body: Option[__string] = None,
    messageType: Option[zio.aws.pinpoint.model.MessageType] = None,
    originationNumber: Option[__string] = None,
    senderId: Option[__string] = None,
    entityId: Option[__string] = None,
    templateId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CampaignSmsMessage = {
    import CampaignSmsMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CampaignSmsMessage
      .builder()
      .optionallyWith(
        body.map(value => __string.unwrap(value): java.lang.String)
      )(_.body)
      .optionallyWith(messageType.map(value => value.unwrap))(_.messageType)
      .optionallyWith(
        originationNumber.map(value => __string.unwrap(value): java.lang.String)
      )(_.originationNumber)
      .optionallyWith(
        senderId.map(value => __string.unwrap(value): java.lang.String)
      )(_.senderId)
      .optionallyWith(
        entityId.map(value => __string.unwrap(value): java.lang.String)
      )(_.entityId)
      .optionallyWith(
        templateId.map(value => __string.unwrap(value): java.lang.String)
      )(_.templateId)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CampaignSmsMessage.ReadOnly =
    zio.aws.pinpoint.model.CampaignSmsMessage.wrap(buildAwsValue())
}
object CampaignSmsMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CampaignSmsMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CampaignSmsMessage =
      zio.aws.pinpoint.model.CampaignSmsMessage(
        body.map(value => value),
        messageType.map(value => value),
        originationNumber.map(value => value),
        senderId.map(value => value),
        entityId.map(value => value),
        templateId.map(value => value)
      )
    def body: Option[__string]
    def messageType: Option[zio.aws.pinpoint.model.MessageType]
    def originationNumber: Option[__string]
    def senderId: Option[__string]
    def entityId: Option[__string]
    def templateId: Option[__string]
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getMessageType: ZIO[Any, AwsError, zio.aws.pinpoint.model.MessageType] =
      AwsError.unwrapOptionField("messageType", messageType)
    def getOriginationNumber: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("originationNumber", originationNumber)
    def getSenderId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("senderId", senderId)
    def getEntityId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("entityId", entityId)
    def getTemplateId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateId", templateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignSmsMessage
  ) extends zio.aws.pinpoint.model.CampaignSmsMessage.ReadOnly {
    override val body: Option[__string] = scala
      .Option(impl.body())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val messageType: Option[zio.aws.pinpoint.model.MessageType] = scala
      .Option(impl.messageType())
      .map(value => zio.aws.pinpoint.model.MessageType.wrap(value))
    override val originationNumber: Option[__string] = scala
      .Option(impl.originationNumber())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val senderId: Option[__string] = scala
      .Option(impl.senderId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val entityId: Option[__string] = scala
      .Option(impl.entityId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val templateId: Option[__string] = scala
      .Option(impl.templateId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignSmsMessage
  ): zio.aws.pinpoint.model.CampaignSmsMessage.ReadOnly = new Wrapper(impl)
}
