package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait CampaignStatus {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.CampaignStatus
}
object CampaignStatus {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.CampaignStatus
  ): zio.aws.pinpoint.model.CampaignStatus = value match {
    case software.amazon.awssdk.services.pinpoint.model.CampaignStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.CampaignStatus.SCHEDULED =>
      val r = SCHEDULED
      r
    case software.amazon.awssdk.services.pinpoint.model.CampaignStatus.EXECUTING =>
      val r = EXECUTING
      r
    case software.amazon.awssdk.services.pinpoint.model.CampaignStatus.PENDING_NEXT_RUN =>
      val r = PENDING_NEXT_RUN
      r
    case software.amazon.awssdk.services.pinpoint.model.CampaignStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.pinpoint.model.CampaignStatus.PAUSED =>
      val r = PAUSED
      r
    case software.amazon.awssdk.services.pinpoint.model.CampaignStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.pinpoint.model.CampaignStatus.INVALID =>
      val r = INVALID
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.pinpoint.model.CampaignStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.CampaignStatus =
      software.amazon.awssdk.services.pinpoint.model.CampaignStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SCHEDULED extends zio.aws.pinpoint.model.CampaignStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.CampaignStatus =
      software.amazon.awssdk.services.pinpoint.model.CampaignStatus.SCHEDULED
  }
  case object EXECUTING extends zio.aws.pinpoint.model.CampaignStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.CampaignStatus =
      software.amazon.awssdk.services.pinpoint.model.CampaignStatus.EXECUTING
  }
  case object PENDING_NEXT_RUN extends zio.aws.pinpoint.model.CampaignStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.CampaignStatus =
      software.amazon.awssdk.services.pinpoint.model.CampaignStatus.PENDING_NEXT_RUN
  }
  case object COMPLETED extends zio.aws.pinpoint.model.CampaignStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.CampaignStatus =
      software.amazon.awssdk.services.pinpoint.model.CampaignStatus.COMPLETED
  }
  case object PAUSED extends zio.aws.pinpoint.model.CampaignStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.CampaignStatus =
      software.amazon.awssdk.services.pinpoint.model.CampaignStatus.PAUSED
  }
  case object DELETED extends zio.aws.pinpoint.model.CampaignStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.CampaignStatus =
      software.amazon.awssdk.services.pinpoint.model.CampaignStatus.DELETED
  }
  case object INVALID extends zio.aws.pinpoint.model.CampaignStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.CampaignStatus =
      software.amazon.awssdk.services.pinpoint.model.CampaignStatus.INVALID
  }
}
