package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Condition(
    conditions: Option[Iterable[zio.aws.pinpoint.model.SimpleCondition]] = None,
    operator: Option[zio.aws.pinpoint.model.Operator] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.Condition = {
    import Condition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.Condition
      .builder()
      .optionallyWith(
        conditions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.conditions)
      .optionallyWith(operator.map(value => value.unwrap))(_.operator)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.Condition.ReadOnly =
    zio.aws.pinpoint.model.Condition.wrap(buildAwsValue())
}
object Condition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.Condition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.Condition =
      zio.aws.pinpoint.model.Condition(
        conditions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        operator.map(value => value)
      )
    def conditions
        : Option[List[zio.aws.pinpoint.model.SimpleCondition.ReadOnly]]
    def operator: Option[zio.aws.pinpoint.model.Operator]
    def getConditions: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.SimpleCondition.ReadOnly
    ]] = AwsError.unwrapOptionField("conditions", conditions)
    def getOperator: ZIO[Any, AwsError, zio.aws.pinpoint.model.Operator] =
      AwsError.unwrapOptionField("operator", operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.Condition
  ) extends zio.aws.pinpoint.model.Condition.ReadOnly {
    override val conditions
        : Option[List[zio.aws.pinpoint.model.SimpleCondition.ReadOnly]] = scala
      .Option(impl.conditions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpoint.model.SimpleCondition.wrap(item)
        }.toList
      )
    override val operator: Option[zio.aws.pinpoint.model.Operator] = scala
      .Option(impl.operator())
      .map(value => zio.aws.pinpoint.model.Operator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.Condition
  ): zio.aws.pinpoint.model.Condition.ReadOnly = new Wrapper(impl)
}
