package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ConditionalSplitActivity(
    condition: Option[zio.aws.pinpoint.model.Condition] = None,
    evaluationWaitTime: Option[zio.aws.pinpoint.model.WaitTime] = None,
    falseActivity: Option[__string] = None,
    trueActivity: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ConditionalSplitActivity = {
    import ConditionalSplitActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ConditionalSplitActivity
      .builder()
      .optionallyWith(condition.map(value => value.buildAwsValue()))(
        _.condition
      )
      .optionallyWith(evaluationWaitTime.map(value => value.buildAwsValue()))(
        _.evaluationWaitTime
      )
      .optionallyWith(
        falseActivity.map(value => __string.unwrap(value): java.lang.String)
      )(_.falseActivity)
      .optionallyWith(
        trueActivity.map(value => __string.unwrap(value): java.lang.String)
      )(_.trueActivity)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ConditionalSplitActivity.ReadOnly =
    zio.aws.pinpoint.model.ConditionalSplitActivity.wrap(buildAwsValue())
}
object ConditionalSplitActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ConditionalSplitActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ConditionalSplitActivity =
      zio.aws.pinpoint.model.ConditionalSplitActivity(
        condition.map(value => value.asEditable),
        evaluationWaitTime.map(value => value.asEditable),
        falseActivity.map(value => value),
        trueActivity.map(value => value)
      )
    def condition: Option[zio.aws.pinpoint.model.Condition.ReadOnly]
    def evaluationWaitTime: Option[zio.aws.pinpoint.model.WaitTime.ReadOnly]
    def falseActivity: Option[__string]
    def trueActivity: Option[__string]
    def getCondition
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Condition.ReadOnly] =
      AwsError.unwrapOptionField("condition", condition)
    def getEvaluationWaitTime
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.WaitTime.ReadOnly] =
      AwsError.unwrapOptionField("evaluationWaitTime", evaluationWaitTime)
    def getFalseActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("falseActivity", falseActivity)
    def getTrueActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("trueActivity", trueActivity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ConditionalSplitActivity
  ) extends zio.aws.pinpoint.model.ConditionalSplitActivity.ReadOnly {
    override val condition: Option[zio.aws.pinpoint.model.Condition.ReadOnly] =
      scala
        .Option(impl.condition())
        .map(value => zio.aws.pinpoint.model.Condition.wrap(value))
    override val evaluationWaitTime
        : Option[zio.aws.pinpoint.model.WaitTime.ReadOnly] = scala
      .Option(impl.evaluationWaitTime())
      .map(value => zio.aws.pinpoint.model.WaitTime.wrap(value))
    override val falseActivity: Option[__string] = scala
      .Option(impl.falseActivity())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val trueActivity: Option[__string] = scala
      .Option(impl.trueActivity())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ConditionalSplitActivity
  ): zio.aws.pinpoint.model.ConditionalSplitActivity.ReadOnly = new Wrapper(
    impl
  )
}
