package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateAppResponse(
    applicationResponse: zio.aws.pinpoint.model.ApplicationResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CreateAppResponse = {
    import CreateAppResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CreateAppResponse
      .builder()
      .applicationResponse(applicationResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CreateAppResponse.ReadOnly =
    zio.aws.pinpoint.model.CreateAppResponse.wrap(buildAwsValue())
}
object CreateAppResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CreateAppResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CreateAppResponse =
      zio.aws.pinpoint.model.CreateAppResponse(applicationResponse.asEditable)
    def applicationResponse: zio.aws.pinpoint.model.ApplicationResponse.ReadOnly
    def getApplicationResponse: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.ApplicationResponse.ReadOnly
    ] = ZIO.succeed(applicationResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateAppResponse
  ) extends zio.aws.pinpoint.model.CreateAppResponse.ReadOnly {
    override val applicationResponse
        : zio.aws.pinpoint.model.ApplicationResponse.ReadOnly =
      zio.aws.pinpoint.model.ApplicationResponse
        .wrap(impl.applicationResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateAppResponse
  ): zio.aws.pinpoint.model.CreateAppResponse.ReadOnly = new Wrapper(impl)
}
