package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreateApplicationRequest(
    name: __string,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CreateApplicationRequest = {
    import CreateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CreateApplicationRequest
      .builder()
      .name(__string.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CreateApplicationRequest.ReadOnly =
    zio.aws.pinpoint.model.CreateApplicationRequest.wrap(buildAwsValue())
}
object CreateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CreateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CreateApplicationRequest =
      zio.aws.pinpoint.model
        .CreateApplicationRequest(name, tags.map(value => value))
    def name: __string
    def tags: Option[Map[__string, __string]]
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateApplicationRequest
  ) extends zio.aws.pinpoint.model.CreateApplicationRequest.ReadOnly {
    override val name: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.name())
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateApplicationRequest
  ): zio.aws.pinpoint.model.CreateApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
