package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreateEmailTemplateRequest(
    emailTemplateRequest: zio.aws.pinpoint.model.EmailTemplateRequest,
    templateName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CreateEmailTemplateRequest = {
    import CreateEmailTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CreateEmailTemplateRequest
      .builder()
      .emailTemplateRequest(emailTemplateRequest.buildAwsValue())
      .templateName(__string.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CreateEmailTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.CreateEmailTemplateRequest.wrap(buildAwsValue())
}
object CreateEmailTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CreateEmailTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CreateEmailTemplateRequest =
      zio.aws.pinpoint.model.CreateEmailTemplateRequest(
        emailTemplateRequest.asEditable,
        templateName
      )
    def emailTemplateRequest
        : zio.aws.pinpoint.model.EmailTemplateRequest.ReadOnly
    def templateName: __string
    def getEmailTemplateRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.EmailTemplateRequest.ReadOnly
    ] = ZIO.succeed(emailTemplateRequest)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateEmailTemplateRequest
  ) extends zio.aws.pinpoint.model.CreateEmailTemplateRequest.ReadOnly {
    override val emailTemplateRequest
        : zio.aws.pinpoint.model.EmailTemplateRequest.ReadOnly =
      zio.aws.pinpoint.model.EmailTemplateRequest
        .wrap(impl.emailTemplateRequest())
    override val templateName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateEmailTemplateRequest
  ): zio.aws.pinpoint.model.CreateEmailTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
