package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreateJourneyRequest(
    applicationId: __string,
    writeJourneyRequest: zio.aws.pinpoint.model.WriteJourneyRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CreateJourneyRequest = {
    import CreateJourneyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CreateJourneyRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .writeJourneyRequest(writeJourneyRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CreateJourneyRequest.ReadOnly =
    zio.aws.pinpoint.model.CreateJourneyRequest.wrap(buildAwsValue())
}
object CreateJourneyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CreateJourneyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CreateJourneyRequest =
      zio.aws.pinpoint.model
        .CreateJourneyRequest(applicationId, writeJourneyRequest.asEditable)
    def applicationId: __string
    def writeJourneyRequest: zio.aws.pinpoint.model.WriteJourneyRequest.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getWriteJourneyRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.WriteJourneyRequest.ReadOnly
    ] = ZIO.succeed(writeJourneyRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateJourneyRequest
  ) extends zio.aws.pinpoint.model.CreateJourneyRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val writeJourneyRequest
        : zio.aws.pinpoint.model.WriteJourneyRequest.ReadOnly =
      zio.aws.pinpoint.model.WriteJourneyRequest
        .wrap(impl.writeJourneyRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateJourneyRequest
  ): zio.aws.pinpoint.model.CreateJourneyRequest.ReadOnly = new Wrapper(impl)
}
