package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreateSmsTemplateRequest(
    smsTemplateRequest: zio.aws.pinpoint.model.SMSTemplateRequest,
    templateName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CreateSmsTemplateRequest = {
    import CreateSmsTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CreateSmsTemplateRequest
      .builder()
      .smsTemplateRequest(smsTemplateRequest.buildAwsValue())
      .templateName(__string.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CreateSmsTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.CreateSmsTemplateRequest.wrap(buildAwsValue())
}
object CreateSmsTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CreateSmsTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CreateSmsTemplateRequest =
      zio.aws.pinpoint.model
        .CreateSmsTemplateRequest(smsTemplateRequest.asEditable, templateName)
    def smsTemplateRequest: zio.aws.pinpoint.model.SMSTemplateRequest.ReadOnly
    def templateName: __string
    def getSmsTemplateRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.SMSTemplateRequest.ReadOnly
    ] = ZIO.succeed(smsTemplateRequest)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateSmsTemplateRequest
  ) extends zio.aws.pinpoint.model.CreateSmsTemplateRequest.ReadOnly {
    override val smsTemplateRequest
        : zio.aws.pinpoint.model.SMSTemplateRequest.ReadOnly =
      zio.aws.pinpoint.model.SMSTemplateRequest.wrap(impl.smsTemplateRequest())
    override val templateName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateSmsTemplateRequest
  ): zio.aws.pinpoint.model.CreateSmsTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
