package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CustomDeliveryConfiguration(
    deliveryUri: __string,
    endpointTypes: Option[
      Iterable[zio.aws.pinpoint.model.EndpointTypesElement]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CustomDeliveryConfiguration = {
    import CustomDeliveryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CustomDeliveryConfiguration
      .builder()
      .deliveryUri(__string.unwrap(deliveryUri): java.lang.String)
      .optionallyWith(
        endpointTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.endpointTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CustomDeliveryConfiguration.ReadOnly =
    zio.aws.pinpoint.model.CustomDeliveryConfiguration.wrap(buildAwsValue())
}
object CustomDeliveryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CustomDeliveryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CustomDeliveryConfiguration =
      zio.aws.pinpoint.model.CustomDeliveryConfiguration(
        deliveryUri,
        endpointTypes.map(value => value)
      )
    def deliveryUri: __string
    def endpointTypes: Option[List[zio.aws.pinpoint.model.EndpointTypesElement]]
    def getDeliveryUri: ZIO[Any, Nothing, __string] = ZIO.succeed(deliveryUri)
    def getEndpointTypes: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.EndpointTypesElement
    ]] = AwsError.unwrapOptionField("endpointTypes", endpointTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CustomDeliveryConfiguration
  ) extends zio.aws.pinpoint.model.CustomDeliveryConfiguration.ReadOnly {
    override val deliveryUri: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.deliveryUri())
    override val endpointTypes
        : Option[List[zio.aws.pinpoint.model.EndpointTypesElement]] = scala
      .Option(impl.endpointTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpoint.model.EndpointTypesElement.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CustomDeliveryConfiguration
  ): zio.aws.pinpoint.model.CustomDeliveryConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
