package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CustomMessageActivity(
    deliveryUri: Option[__string] = None,
    endpointTypes: Option[
      Iterable[zio.aws.pinpoint.model.EndpointTypesElement]
    ] = None,
    messageConfig: Option[zio.aws.pinpoint.model.JourneyCustomMessage] = None,
    nextActivity: Option[__string] = None,
    templateName: Option[__string] = None,
    templateVersion: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CustomMessageActivity = {
    import CustomMessageActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CustomMessageActivity
      .builder()
      .optionallyWith(
        deliveryUri.map(value => __string.unwrap(value): java.lang.String)
      )(_.deliveryUri)
      .optionallyWith(
        endpointTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.endpointTypesWithStrings)
      .optionallyWith(messageConfig.map(value => value.buildAwsValue()))(
        _.messageConfig
      )
      .optionallyWith(
        nextActivity.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextActivity)
      .optionallyWith(
        templateName.map(value => __string.unwrap(value): java.lang.String)
      )(_.templateName)
      .optionallyWith(
        templateVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.templateVersion)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CustomMessageActivity.ReadOnly =
    zio.aws.pinpoint.model.CustomMessageActivity.wrap(buildAwsValue())
}
object CustomMessageActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CustomMessageActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CustomMessageActivity =
      zio.aws.pinpoint.model.CustomMessageActivity(
        deliveryUri.map(value => value),
        endpointTypes.map(value => value),
        messageConfig.map(value => value.asEditable),
        nextActivity.map(value => value),
        templateName.map(value => value),
        templateVersion.map(value => value)
      )
    def deliveryUri: Option[__string]
    def endpointTypes: Option[List[zio.aws.pinpoint.model.EndpointTypesElement]]
    def messageConfig
        : Option[zio.aws.pinpoint.model.JourneyCustomMessage.ReadOnly]
    def nextActivity: Option[__string]
    def templateName: Option[__string]
    def templateVersion: Option[__string]
    def getDeliveryUri: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("deliveryUri", deliveryUri)
    def getEndpointTypes: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.EndpointTypesElement
    ]] = AwsError.unwrapOptionField("endpointTypes", endpointTypes)
    def getMessageConfig: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.JourneyCustomMessage.ReadOnly
    ] = AwsError.unwrapOptionField("messageConfig", messageConfig)
    def getNextActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextActivity", nextActivity)
    def getTemplateName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getTemplateVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateVersion", templateVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CustomMessageActivity
  ) extends zio.aws.pinpoint.model.CustomMessageActivity.ReadOnly {
    override val deliveryUri: Option[__string] = scala
      .Option(impl.deliveryUri())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val endpointTypes
        : Option[List[zio.aws.pinpoint.model.EndpointTypesElement]] = scala
      .Option(impl.endpointTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpoint.model.EndpointTypesElement.wrap(item)
        }.toList
      )
    override val messageConfig
        : Option[zio.aws.pinpoint.model.JourneyCustomMessage.ReadOnly] = scala
      .Option(impl.messageConfig())
      .map(value => zio.aws.pinpoint.model.JourneyCustomMessage.wrap(value))
    override val nextActivity: Option[__string] = scala
      .Option(impl.nextActivity())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val templateName: Option[__string] = scala
      .Option(impl.templateName())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val templateVersion: Option[__string] = scala
      .Option(impl.templateVersion())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CustomMessageActivity
  ): zio.aws.pinpoint.model.CustomMessageActivity.ReadOnly = new Wrapper(impl)
}
