package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class DefaultButtonConfiguration(
    backgroundColor: Option[__string] = None,
    borderRadius: Option[__integer] = None,
    buttonAction: zio.aws.pinpoint.model.ButtonAction,
    link: Option[__string] = None,
    text: __string,
    textColor: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DefaultButtonConfiguration = {
    import DefaultButtonConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DefaultButtonConfiguration
      .builder()
      .optionallyWith(
        backgroundColor.map(value => __string.unwrap(value): java.lang.String)
      )(_.backgroundColor)
      .optionallyWith(
        borderRadius.map(value => __integer.unwrap(value): Integer)
      )(_.borderRadius)
      .buttonAction(buttonAction.unwrap)
      .optionallyWith(
        link.map(value => __string.unwrap(value): java.lang.String)
      )(_.link)
      .text(__string.unwrap(text): java.lang.String)
      .optionallyWith(
        textColor.map(value => __string.unwrap(value): java.lang.String)
      )(_.textColor)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.DefaultButtonConfiguration.ReadOnly =
    zio.aws.pinpoint.model.DefaultButtonConfiguration.wrap(buildAwsValue())
}
object DefaultButtonConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DefaultButtonConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DefaultButtonConfiguration =
      zio.aws.pinpoint.model.DefaultButtonConfiguration(
        backgroundColor.map(value => value),
        borderRadius.map(value => value),
        buttonAction,
        link.map(value => value),
        text,
        textColor.map(value => value)
      )
    def backgroundColor: Option[__string]
    def borderRadius: Option[__integer]
    def buttonAction: zio.aws.pinpoint.model.ButtonAction
    def link: Option[__string]
    def text: __string
    def textColor: Option[__string]
    def getBackgroundColor: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("backgroundColor", backgroundColor)
    def getBorderRadius: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("borderRadius", borderRadius)
    def getButtonAction
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.ButtonAction] =
      ZIO.succeed(buttonAction)
    def getLink: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("link", link)
    def getText: ZIO[Any, Nothing, __string] = ZIO.succeed(text)
    def getTextColor: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("textColor", textColor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DefaultButtonConfiguration
  ) extends zio.aws.pinpoint.model.DefaultButtonConfiguration.ReadOnly {
    override val backgroundColor: Option[__string] = scala
      .Option(impl.backgroundColor())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val borderRadius: Option[__integer] = scala
      .Option(impl.borderRadius())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val buttonAction: zio.aws.pinpoint.model.ButtonAction =
      zio.aws.pinpoint.model.ButtonAction.wrap(impl.buttonAction())
    override val link: Option[__string] = scala
      .Option(impl.link())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val text: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.text())
    override val textColor: Option[__string] = scala
      .Option(impl.textColor())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DefaultButtonConfiguration
  ): zio.aws.pinpoint.model.DefaultButtonConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
