package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__boolean, __string}
import scala.jdk.CollectionConverters.*
final case class DefaultPushNotificationMessage(
    action: Option[zio.aws.pinpoint.model.Action] = None,
    body: Option[__string] = None,
    data: Option[Map[__string, __string]] = None,
    silentPush: Option[__boolean] = None,
    substitutions: Option[Map[__string, Iterable[__string]]] = None,
    title: Option[__string] = None,
    url: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationMessage = {
    import DefaultPushNotificationMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationMessage
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(
        body.map(value => __string.unwrap(value): java.lang.String)
      )(_.body)
      .optionallyWith(
        data.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.data)
      .optionallyWith(
        silentPush.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.silentPush)
      .optionallyWith(
        substitutions.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.map { item =>
                __string.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.substitutions)
      .optionallyWith(
        title.map(value => __string.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        url.map(value => __string.unwrap(value): java.lang.String)
      )(_.url)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.DefaultPushNotificationMessage.ReadOnly =
    zio.aws.pinpoint.model.DefaultPushNotificationMessage.wrap(buildAwsValue())
}
object DefaultPushNotificationMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DefaultPushNotificationMessage =
      zio.aws.pinpoint.model.DefaultPushNotificationMessage(
        action.map(value => value),
        body.map(value => value),
        data.map(value => value),
        silentPush.map(value => value),
        substitutions.map(value => value),
        title.map(value => value),
        url.map(value => value)
      )
    def action: Option[zio.aws.pinpoint.model.Action]
    def body: Option[__string]
    def data: Option[Map[__string, __string]]
    def silentPush: Option[__boolean]
    def substitutions: Option[Map[__string, List[__string]]]
    def title: Option[__string]
    def url: Option[__string]
    def getAction: ZIO[Any, AwsError, zio.aws.pinpoint.model.Action] =
      AwsError.unwrapOptionField("action", action)
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getData: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("data", data)
    def getSilentPush: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("silentPush", silentPush)
    def getSubstitutions: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("substitutions", substitutions)
    def getTitle: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("title", title)
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationMessage
  ) extends zio.aws.pinpoint.model.DefaultPushNotificationMessage.ReadOnly {
    override val action: Option[zio.aws.pinpoint.model.Action] = scala
      .Option(impl.action())
      .map(value => zio.aws.pinpoint.model.Action.wrap(value))
    override val body: Option[__string] = scala
      .Option(impl.body())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val data: Option[Map[__string, __string]] = scala
      .Option(impl.data())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val silentPush: Option[__boolean] = scala
      .Option(impl.silentPush())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val substitutions: Option[Map[__string, List[__string]]] = scala
      .Option(impl.substitutions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives
              .__string(key) -> value.asScala.map { item =>
              zio.aws.pinpoint.model.primitives.__string(item)
            }.toList
          })
          .toMap
      )
    override val title: Option[__string] = scala
      .Option(impl.title())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val url: Option[__string] = scala
      .Option(impl.url())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationMessage
  ): zio.aws.pinpoint.model.DefaultPushNotificationMessage.ReadOnly =
    new Wrapper(impl)
}
