package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteEmailChannelResponse(
    emailChannelResponse: zio.aws.pinpoint.model.EmailChannelResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelResponse = {
    import DeleteEmailChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelResponse
      .builder()
      .emailChannelResponse(emailChannelResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.DeleteEmailChannelResponse.ReadOnly =
    zio.aws.pinpoint.model.DeleteEmailChannelResponse.wrap(buildAwsValue())
}
object DeleteEmailChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DeleteEmailChannelResponse =
      zio.aws.pinpoint.model
        .DeleteEmailChannelResponse(emailChannelResponse.asEditable)
    def emailChannelResponse
        : zio.aws.pinpoint.model.EmailChannelResponse.ReadOnly
    def getEmailChannelResponse: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.EmailChannelResponse.ReadOnly
    ] = ZIO.succeed(emailChannelResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelResponse
  ) extends zio.aws.pinpoint.model.DeleteEmailChannelResponse.ReadOnly {
    override val emailChannelResponse
        : zio.aws.pinpoint.model.EmailChannelResponse.ReadOnly =
      zio.aws.pinpoint.model.EmailChannelResponse
        .wrap(impl.emailChannelResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelResponse
  ): zio.aws.pinpoint.model.DeleteEmailChannelResponse.ReadOnly = new Wrapper(
    impl
  )
}
