package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class DeleteEmailTemplateRequest(
    templateName: __string,
    version: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DeleteEmailTemplateRequest = {
    import DeleteEmailTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DeleteEmailTemplateRequest
      .builder()
      .templateName(__string.unwrap(templateName): java.lang.String)
      .optionallyWith(
        version.map(value => __string.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.DeleteEmailTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.DeleteEmailTemplateRequest.wrap(buildAwsValue())
}
object DeleteEmailTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DeleteEmailTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DeleteEmailTemplateRequest =
      zio.aws.pinpoint.model
        .DeleteEmailTemplateRequest(templateName, version.map(value => value))
    def templateName: __string
    def version: Option[__string]
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteEmailTemplateRequest
  ) extends zio.aws.pinpoint.model.DeleteEmailTemplateRequest.ReadOnly {
    override val templateName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateName())
    override val version: Option[__string] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteEmailTemplateRequest
  ): zio.aws.pinpoint.model.DeleteEmailTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
