package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class DeleteJourneyRequest(
    applicationId: __string,
    journeyId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DeleteJourneyRequest = {
    import DeleteJourneyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DeleteJourneyRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .journeyId(__string.unwrap(journeyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.DeleteJourneyRequest.ReadOnly =
    zio.aws.pinpoint.model.DeleteJourneyRequest.wrap(buildAwsValue())
}
object DeleteJourneyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DeleteJourneyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DeleteJourneyRequest =
      zio.aws.pinpoint.model.DeleteJourneyRequest(applicationId, journeyId)
    def applicationId: __string
    def journeyId: __string
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getJourneyId: ZIO[Any, Nothing, __string] = ZIO.succeed(journeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteJourneyRequest
  ) extends zio.aws.pinpoint.model.DeleteJourneyRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val journeyId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.journeyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteJourneyRequest
  ): zio.aws.pinpoint.model.DeleteJourneyRequest.ReadOnly = new Wrapper(impl)
}
