package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class DeleteSegmentRequest(
    applicationId: __string,
    segmentId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DeleteSegmentRequest = {
    import DeleteSegmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DeleteSegmentRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .segmentId(__string.unwrap(segmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.DeleteSegmentRequest.ReadOnly =
    zio.aws.pinpoint.model.DeleteSegmentRequest.wrap(buildAwsValue())
}
object DeleteSegmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DeleteSegmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DeleteSegmentRequest =
      zio.aws.pinpoint.model.DeleteSegmentRequest(applicationId, segmentId)
    def applicationId: __string
    def segmentId: __string
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getSegmentId: ZIO[Any, Nothing, __string] = ZIO.succeed(segmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteSegmentRequest
  ) extends zio.aws.pinpoint.model.DeleteSegmentRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val segmentId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.segmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteSegmentRequest
  ): zio.aws.pinpoint.model.DeleteSegmentRequest.ReadOnly = new Wrapper(impl)
}
