package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class DeleteSmsTemplateRequest(
    templateName: __string,
    version: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateRequest = {
    import DeleteSmsTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateRequest
      .builder()
      .templateName(__string.unwrap(templateName): java.lang.String)
      .optionallyWith(
        version.map(value => __string.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.DeleteSmsTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.DeleteSmsTemplateRequest.wrap(buildAwsValue())
}
object DeleteSmsTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DeleteSmsTemplateRequest =
      zio.aws.pinpoint.model
        .DeleteSmsTemplateRequest(templateName, version.map(value => value))
    def templateName: __string
    def version: Option[__string]
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateRequest
  ) extends zio.aws.pinpoint.model.DeleteSmsTemplateRequest.ReadOnly {
    override val templateName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateName())
    override val version: Option[__string] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateRequest
  ): zio.aws.pinpoint.model.DeleteSmsTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
