package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DirectMessageConfiguration(
    admMessage: Option[zio.aws.pinpoint.model.ADMMessage] = None,
    apnsMessage: Option[zio.aws.pinpoint.model.APNSMessage] = None,
    baiduMessage: Option[zio.aws.pinpoint.model.BaiduMessage] = None,
    defaultMessage: Option[zio.aws.pinpoint.model.DefaultMessage] = None,
    defaultPushNotificationMessage: Option[
      zio.aws.pinpoint.model.DefaultPushNotificationMessage
    ] = None,
    emailMessage: Option[zio.aws.pinpoint.model.EmailMessage] = None,
    gcmMessage: Option[zio.aws.pinpoint.model.GCMMessage] = None,
    smsMessage: Option[zio.aws.pinpoint.model.SMSMessage] = None,
    voiceMessage: Option[zio.aws.pinpoint.model.VoiceMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DirectMessageConfiguration = {
    import DirectMessageConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DirectMessageConfiguration
      .builder()
      .optionallyWith(admMessage.map(value => value.buildAwsValue()))(
        _.admMessage
      )
      .optionallyWith(apnsMessage.map(value => value.buildAwsValue()))(
        _.apnsMessage
      )
      .optionallyWith(baiduMessage.map(value => value.buildAwsValue()))(
        _.baiduMessage
      )
      .optionallyWith(defaultMessage.map(value => value.buildAwsValue()))(
        _.defaultMessage
      )
      .optionallyWith(
        defaultPushNotificationMessage.map(value => value.buildAwsValue())
      )(_.defaultPushNotificationMessage)
      .optionallyWith(emailMessage.map(value => value.buildAwsValue()))(
        _.emailMessage
      )
      .optionallyWith(gcmMessage.map(value => value.buildAwsValue()))(
        _.gcmMessage
      )
      .optionallyWith(smsMessage.map(value => value.buildAwsValue()))(
        _.smsMessage
      )
      .optionallyWith(voiceMessage.map(value => value.buildAwsValue()))(
        _.voiceMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.DirectMessageConfiguration.ReadOnly =
    zio.aws.pinpoint.model.DirectMessageConfiguration.wrap(buildAwsValue())
}
object DirectMessageConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DirectMessageConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DirectMessageConfiguration =
      zio.aws.pinpoint.model.DirectMessageConfiguration(
        admMessage.map(value => value.asEditable),
        apnsMessage.map(value => value.asEditable),
        baiduMessage.map(value => value.asEditable),
        defaultMessage.map(value => value.asEditable),
        defaultPushNotificationMessage.map(value => value.asEditable),
        emailMessage.map(value => value.asEditable),
        gcmMessage.map(value => value.asEditable),
        smsMessage.map(value => value.asEditable),
        voiceMessage.map(value => value.asEditable)
      )
    def admMessage: Option[zio.aws.pinpoint.model.ADMMessage.ReadOnly]
    def apnsMessage: Option[zio.aws.pinpoint.model.APNSMessage.ReadOnly]
    def baiduMessage: Option[zio.aws.pinpoint.model.BaiduMessage.ReadOnly]
    def defaultMessage: Option[zio.aws.pinpoint.model.DefaultMessage.ReadOnly]
    def defaultPushNotificationMessage
        : Option[zio.aws.pinpoint.model.DefaultPushNotificationMessage.ReadOnly]
    def emailMessage: Option[zio.aws.pinpoint.model.EmailMessage.ReadOnly]
    def gcmMessage: Option[zio.aws.pinpoint.model.GCMMessage.ReadOnly]
    def smsMessage: Option[zio.aws.pinpoint.model.SMSMessage.ReadOnly]
    def voiceMessage: Option[zio.aws.pinpoint.model.VoiceMessage.ReadOnly]
    def getAdmMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.ADMMessage.ReadOnly] =
      AwsError.unwrapOptionField("admMessage", admMessage)
    def getApnsMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.APNSMessage.ReadOnly] =
      AwsError.unwrapOptionField("apnsMessage", apnsMessage)
    def getBaiduMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.BaiduMessage.ReadOnly] =
      AwsError.unwrapOptionField("baiduMessage", baiduMessage)
    def getDefaultMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.DefaultMessage.ReadOnly] =
      AwsError.unwrapOptionField("defaultMessage", defaultMessage)
    def getDefaultPushNotificationMessage: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.DefaultPushNotificationMessage.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultPushNotificationMessage",
      defaultPushNotificationMessage
    )
    def getEmailMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.EmailMessage.ReadOnly] =
      AwsError.unwrapOptionField("emailMessage", emailMessage)
    def getGcmMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.GCMMessage.ReadOnly] =
      AwsError.unwrapOptionField("gcmMessage", gcmMessage)
    def getSmsMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SMSMessage.ReadOnly] =
      AwsError.unwrapOptionField("smsMessage", smsMessage)
    def getVoiceMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.VoiceMessage.ReadOnly] =
      AwsError.unwrapOptionField("voiceMessage", voiceMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DirectMessageConfiguration
  ) extends zio.aws.pinpoint.model.DirectMessageConfiguration.ReadOnly {
    override val admMessage
        : Option[zio.aws.pinpoint.model.ADMMessage.ReadOnly] = scala
      .Option(impl.admMessage())
      .map(value => zio.aws.pinpoint.model.ADMMessage.wrap(value))
    override val apnsMessage
        : Option[zio.aws.pinpoint.model.APNSMessage.ReadOnly] = scala
      .Option(impl.apnsMessage())
      .map(value => zio.aws.pinpoint.model.APNSMessage.wrap(value))
    override val baiduMessage
        : Option[zio.aws.pinpoint.model.BaiduMessage.ReadOnly] = scala
      .Option(impl.baiduMessage())
      .map(value => zio.aws.pinpoint.model.BaiduMessage.wrap(value))
    override val defaultMessage
        : Option[zio.aws.pinpoint.model.DefaultMessage.ReadOnly] = scala
      .Option(impl.defaultMessage())
      .map(value => zio.aws.pinpoint.model.DefaultMessage.wrap(value))
    override val defaultPushNotificationMessage: Option[
      zio.aws.pinpoint.model.DefaultPushNotificationMessage.ReadOnly
    ] = scala
      .Option(impl.defaultPushNotificationMessage())
      .map(value =>
        zio.aws.pinpoint.model.DefaultPushNotificationMessage.wrap(value)
      )
    override val emailMessage
        : Option[zio.aws.pinpoint.model.EmailMessage.ReadOnly] = scala
      .Option(impl.emailMessage())
      .map(value => zio.aws.pinpoint.model.EmailMessage.wrap(value))
    override val gcmMessage
        : Option[zio.aws.pinpoint.model.GCMMessage.ReadOnly] = scala
      .Option(impl.gcmMessage())
      .map(value => zio.aws.pinpoint.model.GCMMessage.wrap(value))
    override val smsMessage
        : Option[zio.aws.pinpoint.model.SMSMessage.ReadOnly] = scala
      .Option(impl.smsMessage())
      .map(value => zio.aws.pinpoint.model.SMSMessage.wrap(value))
    override val voiceMessage
        : Option[zio.aws.pinpoint.model.VoiceMessage.ReadOnly] = scala
      .Option(impl.voiceMessage())
      .map(value => zio.aws.pinpoint.model.VoiceMessage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DirectMessageConfiguration
  ): zio.aws.pinpoint.model.DirectMessageConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
