package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait Duration {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.Duration
}
object Duration {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.Duration
  ): zio.aws.pinpoint.model.Duration = value match {
    case software.amazon.awssdk.services.pinpoint.model.Duration.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.Duration.HR_24 =>
      val r = HR_24
      r
    case software.amazon.awssdk.services.pinpoint.model.Duration.DAY_7 =>
      val r = DAY_7
      r
    case software.amazon.awssdk.services.pinpoint.model.Duration.DAY_14 =>
      val r = DAY_14
      r
    case software.amazon.awssdk.services.pinpoint.model.Duration.DAY_30 =>
      val r = DAY_30
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.Duration {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Duration =
      software.amazon.awssdk.services.pinpoint.model.Duration.UNKNOWN_TO_SDK_VERSION
  }
  case object HR_24 extends zio.aws.pinpoint.model.Duration {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Duration =
      software.amazon.awssdk.services.pinpoint.model.Duration.HR_24
  }
  case object DAY_7 extends zio.aws.pinpoint.model.Duration {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Duration =
      software.amazon.awssdk.services.pinpoint.model.Duration.DAY_7
  }
  case object DAY_14 extends zio.aws.pinpoint.model.Duration {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Duration =
      software.amazon.awssdk.services.pinpoint.model.Duration.DAY_14
  }
  case object DAY_30 extends zio.aws.pinpoint.model.Duration {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Duration =
      software.amazon.awssdk.services.pinpoint.model.Duration.DAY_30
  }
}
