package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__boolean, __string}
import scala.jdk.CollectionConverters.*
final case class EmailChannelRequest(
    configurationSet: Option[__string] = None,
    enabled: Option[__boolean] = None,
    fromAddress: __string,
    identity: __string,
    roleArn: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EmailChannelRequest = {
    import EmailChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EmailChannelRequest
      .builder()
      .optionallyWith(
        configurationSet.map(value => __string.unwrap(value): java.lang.String)
      )(_.configurationSet)
      .optionallyWith(
        enabled.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .fromAddress(__string.unwrap(fromAddress): java.lang.String)
      .identity(__string.unwrap(identity): java.lang.String)
      .optionallyWith(
        roleArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EmailChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.EmailChannelRequest.wrap(buildAwsValue())
}
object EmailChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EmailChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EmailChannelRequest =
      zio.aws.pinpoint.model.EmailChannelRequest(
        configurationSet.map(value => value),
        enabled.map(value => value),
        fromAddress,
        identity,
        roleArn.map(value => value)
      )
    def configurationSet: Option[__string]
    def enabled: Option[__boolean]
    def fromAddress: __string
    def identity: __string
    def roleArn: Option[__string]
    def getConfigurationSet: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("configurationSet", configurationSet)
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getFromAddress: ZIO[Any, Nothing, __string] = ZIO.succeed(fromAddress)
    def getIdentity: ZIO[Any, Nothing, __string] = ZIO.succeed(identity)
    def getRoleArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EmailChannelRequest
  ) extends zio.aws.pinpoint.model.EmailChannelRequest.ReadOnly {
    override val configurationSet: Option[__string] = scala
      .Option(impl.configurationSet())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val enabled: Option[__boolean] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val fromAddress: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.fromAddress())
    override val identity: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.identity())
    override val roleArn: Option[__string] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EmailChannelRequest
  ): zio.aws.pinpoint.model.EmailChannelRequest.ReadOnly = new Wrapper(impl)
}
