package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __boolean, __string}
import scala.jdk.CollectionConverters.*
final case class EmailChannelResponse(
    applicationId: Option[__string] = None,
    configurationSet: Option[__string] = None,
    creationDate: Option[__string] = None,
    enabled: Option[__boolean] = None,
    fromAddress: Option[__string] = None,
    hasCredential: Option[__boolean] = None,
    id: Option[__string] = None,
    identity: Option[__string] = None,
    isArchived: Option[__boolean] = None,
    lastModifiedBy: Option[__string] = None,
    lastModifiedDate: Option[__string] = None,
    messagesPerSecond: Option[__integer] = None,
    platform: __string,
    roleArn: Option[__string] = None,
    version: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EmailChannelResponse = {
    import EmailChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EmailChannelResponse
      .builder()
      .optionallyWith(
        applicationId.map(value => __string.unwrap(value): java.lang.String)
      )(_.applicationId)
      .optionallyWith(
        configurationSet.map(value => __string.unwrap(value): java.lang.String)
      )(_.configurationSet)
      .optionallyWith(
        creationDate.map(value => __string.unwrap(value): java.lang.String)
      )(_.creationDate)
      .optionallyWith(
        enabled.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(
        fromAddress.map(value => __string.unwrap(value): java.lang.String)
      )(_.fromAddress)
      .optionallyWith(
        hasCredential.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.hasCredential)
      .optionallyWith(
        id.map(value => __string.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        identity.map(value => __string.unwrap(value): java.lang.String)
      )(_.identity)
      .optionallyWith(
        isArchived.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.isArchived)
      .optionallyWith(
        lastModifiedBy.map(value => __string.unwrap(value): java.lang.String)
      )(_.lastModifiedBy)
      .optionallyWith(
        lastModifiedDate.map(value => __string.unwrap(value): java.lang.String)
      )(_.lastModifiedDate)
      .optionallyWith(
        messagesPerSecond.map(value => __integer.unwrap(value): Integer)
      )(_.messagesPerSecond)
      .platform(__string.unwrap(platform): java.lang.String)
      .optionallyWith(
        roleArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(version.map(value => __integer.unwrap(value): Integer))(
        _.version
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EmailChannelResponse.ReadOnly =
    zio.aws.pinpoint.model.EmailChannelResponse.wrap(buildAwsValue())
}
object EmailChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EmailChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EmailChannelResponse =
      zio.aws.pinpoint.model.EmailChannelResponse(
        applicationId.map(value => value),
        configurationSet.map(value => value),
        creationDate.map(value => value),
        enabled.map(value => value),
        fromAddress.map(value => value),
        hasCredential.map(value => value),
        id.map(value => value),
        identity.map(value => value),
        isArchived.map(value => value),
        lastModifiedBy.map(value => value),
        lastModifiedDate.map(value => value),
        messagesPerSecond.map(value => value),
        platform,
        roleArn.map(value => value),
        version.map(value => value)
      )
    def applicationId: Option[__string]
    def configurationSet: Option[__string]
    def creationDate: Option[__string]
    def enabled: Option[__boolean]
    def fromAddress: Option[__string]
    def hasCredential: Option[__boolean]
    def id: Option[__string]
    def identity: Option[__string]
    def isArchived: Option[__boolean]
    def lastModifiedBy: Option[__string]
    def lastModifiedDate: Option[__string]
    def messagesPerSecond: Option[__integer]
    def platform: __string
    def roleArn: Option[__string]
    def version: Option[__integer]
    def getApplicationId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getConfigurationSet: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("configurationSet", configurationSet)
    def getCreationDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getFromAddress: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("fromAddress", fromAddress)
    def getHasCredential: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("hasCredential", hasCredential)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getIdentity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("identity", identity)
    def getIsArchived: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("isArchived", isArchived)
    def getLastModifiedBy: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getMessagesPerSecond: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("messagesPerSecond", messagesPerSecond)
    def getPlatform: ZIO[Any, Nothing, __string] = ZIO.succeed(platform)
    def getRoleArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getVersion: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EmailChannelResponse
  ) extends zio.aws.pinpoint.model.EmailChannelResponse.ReadOnly {
    override val applicationId: Option[__string] = scala
      .Option(impl.applicationId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val configurationSet: Option[__string] = scala
      .Option(impl.configurationSet())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val creationDate: Option[__string] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val enabled: Option[__boolean] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val fromAddress: Option[__string] = scala
      .Option(impl.fromAddress())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val hasCredential: Option[__boolean] = scala
      .Option(impl.hasCredential())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val id: Option[__string] = scala
      .Option(impl.id())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val identity: Option[__string] = scala
      .Option(impl.identity())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val isArchived: Option[__boolean] = scala
      .Option(impl.isArchived())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val lastModifiedBy: Option[__string] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val lastModifiedDate: Option[__string] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val messagesPerSecond: Option[__integer] = scala
      .Option(impl.messagesPerSecond())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val platform: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.platform())
    override val roleArn: Option[__string] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val version: Option[__integer] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EmailChannelResponse
  ): zio.aws.pinpoint.model.EmailChannelResponse.ReadOnly = new Wrapper(impl)
}
