package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class EmailMessage(
    body: Option[__string] = None,
    feedbackForwardingAddress: Option[__string] = None,
    fromAddress: Option[__string] = None,
    rawEmail: Option[zio.aws.pinpoint.model.RawEmail] = None,
    replyToAddresses: Option[Iterable[__string]] = None,
    simpleEmail: Option[zio.aws.pinpoint.model.SimpleEmail] = None,
    substitutions: Option[Map[__string, Iterable[__string]]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EmailMessage = {
    import EmailMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EmailMessage
      .builder()
      .optionallyWith(
        body.map(value => __string.unwrap(value): java.lang.String)
      )(_.body)
      .optionallyWith(
        feedbackForwardingAddress.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.feedbackForwardingAddress)
      .optionallyWith(
        fromAddress.map(value => __string.unwrap(value): java.lang.String)
      )(_.fromAddress)
      .optionallyWith(rawEmail.map(value => value.buildAwsValue()))(_.rawEmail)
      .optionallyWith(
        replyToAddresses.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.replyToAddresses)
      .optionallyWith(simpleEmail.map(value => value.buildAwsValue()))(
        _.simpleEmail
      )
      .optionallyWith(
        substitutions.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.map { item =>
                __string.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.substitutions)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EmailMessage.ReadOnly =
    zio.aws.pinpoint.model.EmailMessage.wrap(buildAwsValue())
}
object EmailMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EmailMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EmailMessage =
      zio.aws.pinpoint.model.EmailMessage(
        body.map(value => value),
        feedbackForwardingAddress.map(value => value),
        fromAddress.map(value => value),
        rawEmail.map(value => value.asEditable),
        replyToAddresses.map(value => value),
        simpleEmail.map(value => value.asEditable),
        substitutions.map(value => value)
      )
    def body: Option[__string]
    def feedbackForwardingAddress: Option[__string]
    def fromAddress: Option[__string]
    def rawEmail: Option[zio.aws.pinpoint.model.RawEmail.ReadOnly]
    def replyToAddresses: Option[List[__string]]
    def simpleEmail: Option[zio.aws.pinpoint.model.SimpleEmail.ReadOnly]
    def substitutions: Option[Map[__string, List[__string]]]
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getFeedbackForwardingAddress: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("feedbackForwardingAddress", feedbackForwardingAddress)
    def getFromAddress: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("fromAddress", fromAddress)
    def getRawEmail
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.RawEmail.ReadOnly] =
      AwsError.unwrapOptionField("rawEmail", rawEmail)
    def getReplyToAddresses: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("replyToAddresses", replyToAddresses)
    def getSimpleEmail
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SimpleEmail.ReadOnly] =
      AwsError.unwrapOptionField("simpleEmail", simpleEmail)
    def getSubstitutions: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("substitutions", substitutions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EmailMessage
  ) extends zio.aws.pinpoint.model.EmailMessage.ReadOnly {
    override val body: Option[__string] = scala
      .Option(impl.body())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val feedbackForwardingAddress: Option[__string] = scala
      .Option(impl.feedbackForwardingAddress())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val fromAddress: Option[__string] = scala
      .Option(impl.fromAddress())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val rawEmail: Option[zio.aws.pinpoint.model.RawEmail.ReadOnly] =
      scala
        .Option(impl.rawEmail())
        .map(value => zio.aws.pinpoint.model.RawEmail.wrap(value))
    override val replyToAddresses: Option[List[__string]] = scala
      .Option(impl.replyToAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpoint.model.primitives.__string(item)
        }.toList
      )
    override val simpleEmail
        : Option[zio.aws.pinpoint.model.SimpleEmail.ReadOnly] = scala
      .Option(impl.simpleEmail())
      .map(value => zio.aws.pinpoint.model.SimpleEmail.wrap(value))
    override val substitutions: Option[Map[__string, List[__string]]] = scala
      .Option(impl.substitutions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives
              .__string(key) -> value.asScala.map { item =>
              zio.aws.pinpoint.model.primitives.__string(item)
            }.toList
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EmailMessage
  ): zio.aws.pinpoint.model.EmailMessage.ReadOnly = new Wrapper(impl)
}
