package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class EmailTemplateRequest(
    defaultSubstitutions: Option[__string] = None,
    htmlPart: Option[__string] = None,
    recommenderId: Option[__string] = None,
    subject: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None,
    templateDescription: Option[__string] = None,
    textPart: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EmailTemplateRequest = {
    import EmailTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EmailTemplateRequest
      .builder()
      .optionallyWith(
        defaultSubstitutions.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.defaultSubstitutions)
      .optionallyWith(
        htmlPart.map(value => __string.unwrap(value): java.lang.String)
      )(_.htmlPart)
      .optionallyWith(
        recommenderId.map(value => __string.unwrap(value): java.lang.String)
      )(_.recommenderId)
      .optionallyWith(
        subject.map(value => __string.unwrap(value): java.lang.String)
      )(_.subject)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateDescription.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.templateDescription)
      .optionallyWith(
        textPart.map(value => __string.unwrap(value): java.lang.String)
      )(_.textPart)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EmailTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.EmailTemplateRequest.wrap(buildAwsValue())
}
object EmailTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EmailTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EmailTemplateRequest =
      zio.aws.pinpoint.model.EmailTemplateRequest(
        defaultSubstitutions.map(value => value),
        htmlPart.map(value => value),
        recommenderId.map(value => value),
        subject.map(value => value),
        tags.map(value => value),
        templateDescription.map(value => value),
        textPart.map(value => value)
      )
    def defaultSubstitutions: Option[__string]
    def htmlPart: Option[__string]
    def recommenderId: Option[__string]
    def subject: Option[__string]
    def tags: Option[Map[__string, __string]]
    def templateDescription: Option[__string]
    def textPart: Option[__string]
    def getDefaultSubstitutions: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("defaultSubstitutions", defaultSubstitutions)
    def getHtmlPart: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("htmlPart", htmlPart)
    def getRecommenderId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("recommenderId", recommenderId)
    def getSubject: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("subject", subject)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
    def getTextPart: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("textPart", textPart)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EmailTemplateRequest
  ) extends zio.aws.pinpoint.model.EmailTemplateRequest.ReadOnly {
    override val defaultSubstitutions: Option[__string] = scala
      .Option(impl.defaultSubstitutions())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val htmlPart: Option[__string] = scala
      .Option(impl.htmlPart())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val recommenderId: Option[__string] = scala
      .Option(impl.recommenderId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val subject: Option[__string] = scala
      .Option(impl.subject())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val templateDescription: Option[__string] = scala
      .Option(impl.templateDescription())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val textPart: Option[__string] = scala
      .Option(impl.textPart())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EmailTemplateRequest
  ): zio.aws.pinpoint.model.EmailTemplateRequest.ReadOnly = new Wrapper(impl)
}
