package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class EmailTemplateResponse(
    arn: Option[__string] = None,
    creationDate: __string,
    defaultSubstitutions: Option[__string] = None,
    htmlPart: Option[__string] = None,
    lastModifiedDate: __string,
    recommenderId: Option[__string] = None,
    subject: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None,
    templateDescription: Option[__string] = None,
    templateName: __string,
    templateType: zio.aws.pinpoint.model.TemplateType,
    textPart: Option[__string] = None,
    version: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EmailTemplateResponse = {
    import EmailTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EmailTemplateResponse
      .builder()
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .creationDate(__string.unwrap(creationDate): java.lang.String)
      .optionallyWith(
        defaultSubstitutions.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.defaultSubstitutions)
      .optionallyWith(
        htmlPart.map(value => __string.unwrap(value): java.lang.String)
      )(_.htmlPart)
      .lastModifiedDate(__string.unwrap(lastModifiedDate): java.lang.String)
      .optionallyWith(
        recommenderId.map(value => __string.unwrap(value): java.lang.String)
      )(_.recommenderId)
      .optionallyWith(
        subject.map(value => __string.unwrap(value): java.lang.String)
      )(_.subject)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateDescription.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.templateDescription)
      .templateName(__string.unwrap(templateName): java.lang.String)
      .templateType(templateType.unwrap)
      .optionallyWith(
        textPart.map(value => __string.unwrap(value): java.lang.String)
      )(_.textPart)
      .optionallyWith(
        version.map(value => __string.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EmailTemplateResponse.ReadOnly =
    zio.aws.pinpoint.model.EmailTemplateResponse.wrap(buildAwsValue())
}
object EmailTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EmailTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EmailTemplateResponse =
      zio.aws.pinpoint.model.EmailTemplateResponse(
        arn.map(value => value),
        creationDate,
        defaultSubstitutions.map(value => value),
        htmlPart.map(value => value),
        lastModifiedDate,
        recommenderId.map(value => value),
        subject.map(value => value),
        tags.map(value => value),
        templateDescription.map(value => value),
        templateName,
        templateType,
        textPart.map(value => value),
        version.map(value => value)
      )
    def arn: Option[__string]
    def creationDate: __string
    def defaultSubstitutions: Option[__string]
    def htmlPart: Option[__string]
    def lastModifiedDate: __string
    def recommenderId: Option[__string]
    def subject: Option[__string]
    def tags: Option[Map[__string, __string]]
    def templateDescription: Option[__string]
    def templateName: __string
    def templateType: zio.aws.pinpoint.model.TemplateType
    def textPart: Option[__string]
    def version: Option[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationDate: ZIO[Any, Nothing, __string] = ZIO.succeed(creationDate)
    def getDefaultSubstitutions: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("defaultSubstitutions", defaultSubstitutions)
    def getHtmlPart: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("htmlPart", htmlPart)
    def getLastModifiedDate: ZIO[Any, Nothing, __string] =
      ZIO.succeed(lastModifiedDate)
    def getRecommenderId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("recommenderId", recommenderId)
    def getSubject: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("subject", subject)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getTemplateType
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.TemplateType] =
      ZIO.succeed(templateType)
    def getTextPart: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("textPart", textPart)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EmailTemplateResponse
  ) extends zio.aws.pinpoint.model.EmailTemplateResponse.ReadOnly {
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val creationDate: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.creationDate())
    override val defaultSubstitutions: Option[__string] = scala
      .Option(impl.defaultSubstitutions())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val htmlPart: Option[__string] = scala
      .Option(impl.htmlPart())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val lastModifiedDate: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.lastModifiedDate())
    override val recommenderId: Option[__string] = scala
      .Option(impl.recommenderId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val subject: Option[__string] = scala
      .Option(impl.subject())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val templateDescription: Option[__string] = scala
      .Option(impl.templateDescription())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val templateName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateName())
    override val templateType: zio.aws.pinpoint.model.TemplateType =
      zio.aws.pinpoint.model.TemplateType.wrap(impl.templateType())
    override val textPart: Option[__string] = scala
      .Option(impl.textPart())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val version: Option[__string] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EmailTemplateResponse
  ): zio.aws.pinpoint.model.EmailTemplateResponse.ReadOnly = new Wrapper(impl)
}
