package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class EndpointDemographic(
    appVersion: Option[__string] = None,
    locale: Option[__string] = None,
    make: Option[__string] = None,
    model: Option[__string] = None,
    modelVersion: Option[__string] = None,
    platform: Option[__string] = None,
    platformVersion: Option[__string] = None,
    timezone: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EndpointDemographic = {
    import EndpointDemographic.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EndpointDemographic
      .builder()
      .optionallyWith(
        appVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.appVersion)
      .optionallyWith(
        locale.map(value => __string.unwrap(value): java.lang.String)
      )(_.locale)
      .optionallyWith(
        make.map(value => __string.unwrap(value): java.lang.String)
      )(_.make)
      .optionallyWith(
        model.map(value => __string.unwrap(value): java.lang.String)
      )(_.model)
      .optionallyWith(
        modelVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.modelVersion)
      .optionallyWith(
        platform.map(value => __string.unwrap(value): java.lang.String)
      )(_.platform)
      .optionallyWith(
        platformVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.platformVersion)
      .optionallyWith(
        timezone.map(value => __string.unwrap(value): java.lang.String)
      )(_.timezone)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EndpointDemographic.ReadOnly =
    zio.aws.pinpoint.model.EndpointDemographic.wrap(buildAwsValue())
}
object EndpointDemographic {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EndpointDemographic
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EndpointDemographic =
      zio.aws.pinpoint.model.EndpointDemographic(
        appVersion.map(value => value),
        locale.map(value => value),
        make.map(value => value),
        model.map(value => value),
        modelVersion.map(value => value),
        platform.map(value => value),
        platformVersion.map(value => value),
        timezone.map(value => value)
      )
    def appVersion: Option[__string]
    def locale: Option[__string]
    def make: Option[__string]
    def model: Option[__string]
    def modelVersion: Option[__string]
    def platform: Option[__string]
    def platformVersion: Option[__string]
    def timezone: Option[__string]
    def getAppVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appVersion", appVersion)
    def getLocale: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("locale", locale)
    def getMake: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("make", make)
    def getModel: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("model", model)
    def getModelVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("modelVersion", modelVersion)
    def getPlatform: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("platform", platform)
    def getPlatformVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getTimezone: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("timezone", timezone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointDemographic
  ) extends zio.aws.pinpoint.model.EndpointDemographic.ReadOnly {
    override val appVersion: Option[__string] = scala
      .Option(impl.appVersion())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val locale: Option[__string] = scala
      .Option(impl.locale())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val make: Option[__string] = scala
      .Option(impl.make())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val model: Option[__string] = scala
      .Option(impl.model())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val modelVersion: Option[__string] = scala
      .Option(impl.modelVersion())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val platform: Option[__string] = scala
      .Option(impl.platform())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val platformVersion: Option[__string] = scala
      .Option(impl.platformVersion())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val timezone: Option[__string] = scala
      .Option(impl.timezone())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointDemographic
  ): zio.aws.pinpoint.model.EndpointDemographic.ReadOnly = new Wrapper(impl)
}
