package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__double, __string}
import scala.jdk.CollectionConverters.*
final case class EndpointLocation(
    city: Option[__string] = None,
    country: Option[__string] = None,
    latitude: Option[__double] = None,
    longitude: Option[__double] = None,
    postalCode: Option[__string] = None,
    region: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EndpointLocation = {
    import EndpointLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EndpointLocation
      .builder()
      .optionallyWith(
        city.map(value => __string.unwrap(value): java.lang.String)
      )(_.city)
      .optionallyWith(
        country.map(value => __string.unwrap(value): java.lang.String)
      )(_.country)
      .optionallyWith(
        latitude.map(value => __double.unwrap(value): java.lang.Double)
      )(_.latitude)
      .optionallyWith(
        longitude.map(value => __double.unwrap(value): java.lang.Double)
      )(_.longitude)
      .optionallyWith(
        postalCode.map(value => __string.unwrap(value): java.lang.String)
      )(_.postalCode)
      .optionallyWith(
        region.map(value => __string.unwrap(value): java.lang.String)
      )(_.region)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EndpointLocation.ReadOnly =
    zio.aws.pinpoint.model.EndpointLocation.wrap(buildAwsValue())
}
object EndpointLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EndpointLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EndpointLocation =
      zio.aws.pinpoint.model.EndpointLocation(
        city.map(value => value),
        country.map(value => value),
        latitude.map(value => value),
        longitude.map(value => value),
        postalCode.map(value => value),
        region.map(value => value)
      )
    def city: Option[__string]
    def country: Option[__string]
    def latitude: Option[__double]
    def longitude: Option[__double]
    def postalCode: Option[__string]
    def region: Option[__string]
    def getCity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("city", city)
    def getCountry: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("country", country)
    def getLatitude: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("latitude", latitude)
    def getLongitude: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("longitude", longitude)
    def getPostalCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("postalCode", postalCode)
    def getRegion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointLocation
  ) extends zio.aws.pinpoint.model.EndpointLocation.ReadOnly {
    override val city: Option[__string] = scala
      .Option(impl.city())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val country: Option[__string] = scala
      .Option(impl.country())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val latitude: Option[__double] = scala
      .Option(impl.latitude())
      .map(value => zio.aws.pinpoint.model.primitives.__double(value))
    override val longitude: Option[__double] = scala
      .Option(impl.longitude())
      .map(value => zio.aws.pinpoint.model.primitives.__double(value))
    override val postalCode: Option[__string] = scala
      .Option(impl.postalCode())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val region: Option[__string] = scala
      .Option(impl.region())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointLocation
  ): zio.aws.pinpoint.model.EndpointLocation.ReadOnly = new Wrapper(impl)
}
