package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__double, __string}
import scala.jdk.CollectionConverters.*
final case class EndpointResponse(
    address: Option[__string] = None,
    applicationId: Option[__string] = None,
    attributes: Option[Map[__string, Iterable[__string]]] = None,
    channelType: Option[zio.aws.pinpoint.model.ChannelType] = None,
    cohortId: Option[__string] = None,
    creationDate: Option[__string] = None,
    demographic: Option[zio.aws.pinpoint.model.EndpointDemographic] = None,
    effectiveDate: Option[__string] = None,
    endpointStatus: Option[__string] = None,
    id: Option[__string] = None,
    location: Option[zio.aws.pinpoint.model.EndpointLocation] = None,
    metrics: Option[Map[__string, __double]] = None,
    optOut: Option[__string] = None,
    requestId: Option[__string] = None,
    user: Option[zio.aws.pinpoint.model.EndpointUser] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EndpointResponse = {
    import EndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EndpointResponse
      .builder()
      .optionallyWith(
        address.map(value => __string.unwrap(value): java.lang.String)
      )(_.address)
      .optionallyWith(
        applicationId.map(value => __string.unwrap(value): java.lang.String)
      )(_.applicationId)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.map { item =>
                __string.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(channelType.map(value => value.unwrap))(_.channelType)
      .optionallyWith(
        cohortId.map(value => __string.unwrap(value): java.lang.String)
      )(_.cohortId)
      .optionallyWith(
        creationDate.map(value => __string.unwrap(value): java.lang.String)
      )(_.creationDate)
      .optionallyWith(demographic.map(value => value.buildAwsValue()))(
        _.demographic
      )
      .optionallyWith(
        effectiveDate.map(value => __string.unwrap(value): java.lang.String)
      )(_.effectiveDate)
      .optionallyWith(
        endpointStatus.map(value => __string.unwrap(value): java.lang.String)
      )(_.endpointStatus)
      .optionallyWith(
        id.map(value => __string.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(
        metrics.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__double.unwrap(
                value
              ): java.lang.Double)
            })
            .asJava
        )
      )(_.metrics)
      .optionallyWith(
        optOut.map(value => __string.unwrap(value): java.lang.String)
      )(_.optOut)
      .optionallyWith(
        requestId.map(value => __string.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EndpointResponse.ReadOnly =
    zio.aws.pinpoint.model.EndpointResponse.wrap(buildAwsValue())
}
object EndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EndpointResponse =
      zio.aws.pinpoint.model.EndpointResponse(
        address.map(value => value),
        applicationId.map(value => value),
        attributes.map(value => value),
        channelType.map(value => value),
        cohortId.map(value => value),
        creationDate.map(value => value),
        demographic.map(value => value.asEditable),
        effectiveDate.map(value => value),
        endpointStatus.map(value => value),
        id.map(value => value),
        location.map(value => value.asEditable),
        metrics.map(value => value),
        optOut.map(value => value),
        requestId.map(value => value),
        user.map(value => value.asEditable)
      )
    def address: Option[__string]
    def applicationId: Option[__string]
    def attributes: Option[Map[__string, List[__string]]]
    def channelType: Option[zio.aws.pinpoint.model.ChannelType]
    def cohortId: Option[__string]
    def creationDate: Option[__string]
    def demographic: Option[zio.aws.pinpoint.model.EndpointDemographic.ReadOnly]
    def effectiveDate: Option[__string]
    def endpointStatus: Option[__string]
    def id: Option[__string]
    def location: Option[zio.aws.pinpoint.model.EndpointLocation.ReadOnly]
    def metrics: Option[Map[__string, __double]]
    def optOut: Option[__string]
    def requestId: Option[__string]
    def user: Option[zio.aws.pinpoint.model.EndpointUser.ReadOnly]
    def getAddress: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("address", address)
    def getApplicationId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getAttributes: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getChannelType: ZIO[Any, AwsError, zio.aws.pinpoint.model.ChannelType] =
      AwsError.unwrapOptionField("channelType", channelType)
    def getCohortId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("cohortId", cohortId)
    def getCreationDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getDemographic: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.EndpointDemographic.ReadOnly
    ] = AwsError.unwrapOptionField("demographic", demographic)
    def getEffectiveDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("effectiveDate", effectiveDate)
    def getEndpointStatus: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("endpointStatus", endpointStatus)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.EndpointLocation.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getMetrics: ZIO[Any, AwsError, Map[__string, __double]] =
      AwsError.unwrapOptionField("metrics", metrics)
    def getOptOut: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("optOut", optOut)
    def getRequestId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getUser
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.EndpointUser.ReadOnly] =
      AwsError.unwrapOptionField("user", user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointResponse
  ) extends zio.aws.pinpoint.model.EndpointResponse.ReadOnly {
    override val address: Option[__string] = scala
      .Option(impl.address())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val applicationId: Option[__string] = scala
      .Option(impl.applicationId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val attributes: Option[Map[__string, List[__string]]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives
              .__string(key) -> value.asScala.map { item =>
              zio.aws.pinpoint.model.primitives.__string(item)
            }.toList
          })
          .toMap
      )
    override val channelType: Option[zio.aws.pinpoint.model.ChannelType] = scala
      .Option(impl.channelType())
      .map(value => zio.aws.pinpoint.model.ChannelType.wrap(value))
    override val cohortId: Option[__string] = scala
      .Option(impl.cohortId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val creationDate: Option[__string] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val demographic
        : Option[zio.aws.pinpoint.model.EndpointDemographic.ReadOnly] = scala
      .Option(impl.demographic())
      .map(value => zio.aws.pinpoint.model.EndpointDemographic.wrap(value))
    override val effectiveDate: Option[__string] = scala
      .Option(impl.effectiveDate())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val endpointStatus: Option[__string] = scala
      .Option(impl.endpointStatus())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val id: Option[__string] = scala
      .Option(impl.id())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val location
        : Option[zio.aws.pinpoint.model.EndpointLocation.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.pinpoint.model.EndpointLocation.wrap(value))
    override val metrics: Option[Map[__string, __double]] = scala
      .Option(impl.metrics())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__double(value)
          })
          .toMap
      )
    override val optOut: Option[__string] = scala
      .Option(impl.optOut())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val requestId: Option[__string] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val user: Option[zio.aws.pinpoint.model.EndpointUser.ReadOnly] =
      scala
        .Option(impl.user())
        .map(value => zio.aws.pinpoint.model.EndpointUser.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointResponse
  ): zio.aws.pinpoint.model.EndpointResponse.ReadOnly = new Wrapper(impl)
}
