package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class EndpointSendConfiguration(
    bodyOverride: Option[__string] = None,
    context: Option[Map[__string, __string]] = None,
    rawContent: Option[__string] = None,
    substitutions: Option[Map[__string, Iterable[__string]]] = None,
    titleOverride: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EndpointSendConfiguration = {
    import EndpointSendConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EndpointSendConfiguration
      .builder()
      .optionallyWith(
        bodyOverride.map(value => __string.unwrap(value): java.lang.String)
      )(_.bodyOverride)
      .optionallyWith(
        context.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.context)
      .optionallyWith(
        rawContent.map(value => __string.unwrap(value): java.lang.String)
      )(_.rawContent)
      .optionallyWith(
        substitutions.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.map { item =>
                __string.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.substitutions)
      .optionallyWith(
        titleOverride.map(value => __string.unwrap(value): java.lang.String)
      )(_.titleOverride)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EndpointSendConfiguration.ReadOnly =
    zio.aws.pinpoint.model.EndpointSendConfiguration.wrap(buildAwsValue())
}
object EndpointSendConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EndpointSendConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EndpointSendConfiguration =
      zio.aws.pinpoint.model.EndpointSendConfiguration(
        bodyOverride.map(value => value),
        context.map(value => value),
        rawContent.map(value => value),
        substitutions.map(value => value),
        titleOverride.map(value => value)
      )
    def bodyOverride: Option[__string]
    def context: Option[Map[__string, __string]]
    def rawContent: Option[__string]
    def substitutions: Option[Map[__string, List[__string]]]
    def titleOverride: Option[__string]
    def getBodyOverride: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bodyOverride", bodyOverride)
    def getContext: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("context", context)
    def getRawContent: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("rawContent", rawContent)
    def getSubstitutions: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("substitutions", substitutions)
    def getTitleOverride: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("titleOverride", titleOverride)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointSendConfiguration
  ) extends zio.aws.pinpoint.model.EndpointSendConfiguration.ReadOnly {
    override val bodyOverride: Option[__string] = scala
      .Option(impl.bodyOverride())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val context: Option[Map[__string, __string]] = scala
      .Option(impl.context())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val rawContent: Option[__string] = scala
      .Option(impl.rawContent())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val substitutions: Option[Map[__string, List[__string]]] = scala
      .Option(impl.substitutions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives
              .__string(key) -> value.asScala.map { item =>
              zio.aws.pinpoint.model.primitives.__string(item)
            }.toList
          })
          .toMap
      )
    override val titleOverride: Option[__string] = scala
      .Option(impl.titleOverride())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointSendConfiguration
  ): zio.aws.pinpoint.model.EndpointSendConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
