package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class EndpointUser(
    userAttributes: Option[Map[__string, Iterable[__string]]] = None,
    userId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EndpointUser = {
    import EndpointUser.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EndpointUser
      .builder()
      .optionallyWith(
        userAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.map { item =>
                __string.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.userAttributes)
      .optionallyWith(
        userId.map(value => __string.unwrap(value): java.lang.String)
      )(_.userId)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EndpointUser.ReadOnly =
    zio.aws.pinpoint.model.EndpointUser.wrap(buildAwsValue())
}
object EndpointUser {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EndpointUser
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EndpointUser =
      zio.aws.pinpoint.model.EndpointUser(
        userAttributes.map(value => value),
        userId.map(value => value)
      )
    def userAttributes: Option[Map[__string, List[__string]]]
    def userId: Option[__string]
    def getUserAttributes: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("userAttributes", userAttributes)
    def getUserId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointUser
  ) extends zio.aws.pinpoint.model.EndpointUser.ReadOnly {
    override val userAttributes: Option[Map[__string, List[__string]]] = scala
      .Option(impl.userAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives
              .__string(key) -> value.asScala.map { item =>
              zio.aws.pinpoint.model.primitives.__string(item)
            }.toList
          })
          .toMap
      )
    override val userId: Option[__string] = scala
      .Option(impl.userId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointUser
  ): zio.aws.pinpoint.model.EndpointUser.ReadOnly = new Wrapper(impl)
}
