package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__double, __string}
import scala.jdk.CollectionConverters.*
final case class Event(
    appPackageName: Option[__string] = None,
    appTitle: Option[__string] = None,
    appVersionCode: Option[__string] = None,
    attributes: Option[Map[__string, __string]] = None,
    clientSdkVersion: Option[__string] = None,
    eventType: __string,
    metrics: Option[Map[__string, __double]] = None,
    sdkName: Option[__string] = None,
    session: Option[zio.aws.pinpoint.model.Session] = None,
    timestamp: __string
) {
  def buildAwsValue(): software.amazon.awssdk.services.pinpoint.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.Event
      .builder()
      .optionallyWith(
        appPackageName.map(value => __string.unwrap(value): java.lang.String)
      )(_.appPackageName)
      .optionallyWith(
        appTitle.map(value => __string.unwrap(value): java.lang.String)
      )(_.appTitle)
      .optionallyWith(
        appVersionCode.map(value => __string.unwrap(value): java.lang.String)
      )(_.appVersionCode)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(
        clientSdkVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.clientSdkVersion)
      .eventType(__string.unwrap(eventType): java.lang.String)
      .optionallyWith(
        metrics.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__double.unwrap(
                value
              ): java.lang.Double)
            })
            .asJava
        )
      )(_.metrics)
      .optionallyWith(
        sdkName.map(value => __string.unwrap(value): java.lang.String)
      )(_.sdkName)
      .optionallyWith(session.map(value => value.buildAwsValue()))(_.session)
      .timestamp(__string.unwrap(timestamp): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.Event.ReadOnly =
    zio.aws.pinpoint.model.Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pinpoint.model.Event] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.Event = zio.aws.pinpoint.model.Event(
      appPackageName.map(value => value),
      appTitle.map(value => value),
      appVersionCode.map(value => value),
      attributes.map(value => value),
      clientSdkVersion.map(value => value),
      eventType,
      metrics.map(value => value),
      sdkName.map(value => value),
      session.map(value => value.asEditable),
      timestamp
    )
    def appPackageName: Option[__string]
    def appTitle: Option[__string]
    def appVersionCode: Option[__string]
    def attributes: Option[Map[__string, __string]]
    def clientSdkVersion: Option[__string]
    def eventType: __string
    def metrics: Option[Map[__string, __double]]
    def sdkName: Option[__string]
    def session: Option[zio.aws.pinpoint.model.Session.ReadOnly]
    def timestamp: __string
    def getAppPackageName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appPackageName", appPackageName)
    def getAppTitle: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appTitle", appTitle)
    def getAppVersionCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appVersionCode", appVersionCode)
    def getAttributes: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getClientSdkVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientSdkVersion", clientSdkVersion)
    def getEventType: ZIO[Any, Nothing, __string] = ZIO.succeed(eventType)
    def getMetrics: ZIO[Any, AwsError, Map[__string, __double]] =
      AwsError.unwrapOptionField("metrics", metrics)
    def getSdkName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sdkName", sdkName)
    def getSession
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Session.ReadOnly] =
      AwsError.unwrapOptionField("session", session)
    def getTimestamp: ZIO[Any, Nothing, __string] = ZIO.succeed(timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.Event
  ) extends zio.aws.pinpoint.model.Event.ReadOnly {
    override val appPackageName: Option[__string] = scala
      .Option(impl.appPackageName())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val appTitle: Option[__string] = scala
      .Option(impl.appTitle())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val appVersionCode: Option[__string] = scala
      .Option(impl.appVersionCode())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val attributes: Option[Map[__string, __string]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val clientSdkVersion: Option[__string] = scala
      .Option(impl.clientSdkVersion())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val eventType: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.eventType())
    override val metrics: Option[Map[__string, __double]] = scala
      .Option(impl.metrics())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__double(value)
          })
          .toMap
      )
    override val sdkName: Option[__string] = scala
      .Option(impl.sdkName())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val session: Option[zio.aws.pinpoint.model.Session.ReadOnly] =
      scala
        .Option(impl.session())
        .map(value => zio.aws.pinpoint.model.Session.wrap(value))
    override val timestamp: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.timestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.Event
  ): zio.aws.pinpoint.model.Event.ReadOnly = new Wrapper(impl)
}
