package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class EventItemResponse(
    message: Option[__string] = None,
    statusCode: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EventItemResponse = {
    import EventItemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EventItemResponse
      .builder()
      .optionallyWith(
        message.map(value => __string.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        statusCode.map(value => __integer.unwrap(value): Integer)
      )(_.statusCode)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EventItemResponse.ReadOnly =
    zio.aws.pinpoint.model.EventItemResponse.wrap(buildAwsValue())
}
object EventItemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EventItemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EventItemResponse =
      zio.aws.pinpoint.model.EventItemResponse(
        message.map(value => value),
        statusCode.map(value => value)
      )
    def message: Option[__string]
    def statusCode: Option[__integer]
    def getMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("message", message)
    def getStatusCode: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("statusCode", statusCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EventItemResponse
  ) extends zio.aws.pinpoint.model.EventItemResponse.ReadOnly {
    override val message: Option[__string] = scala
      .Option(impl.message())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val statusCode: Option[__integer] = scala
      .Option(impl.statusCode())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EventItemResponse
  ): zio.aws.pinpoint.model.EventItemResponse.ReadOnly = new Wrapper(impl)
}
