package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class EventStream(
    applicationId: __string,
    destinationStreamArn: __string,
    externalId: Option[__string] = None,
    lastModifiedDate: Option[__string] = None,
    lastUpdatedBy: Option[__string] = None,
    roleArn: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EventStream = {
    import EventStream.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EventStream
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .destinationStreamArn(
        __string.unwrap(destinationStreamArn): java.lang.String
      )
      .optionallyWith(
        externalId.map(value => __string.unwrap(value): java.lang.String)
      )(_.externalId)
      .optionallyWith(
        lastModifiedDate.map(value => __string.unwrap(value): java.lang.String)
      )(_.lastModifiedDate)
      .optionallyWith(
        lastUpdatedBy.map(value => __string.unwrap(value): java.lang.String)
      )(_.lastUpdatedBy)
      .roleArn(__string.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EventStream.ReadOnly =
    zio.aws.pinpoint.model.EventStream.wrap(buildAwsValue())
}
object EventStream {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EventStream
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EventStream =
      zio.aws.pinpoint.model.EventStream(
        applicationId,
        destinationStreamArn,
        externalId.map(value => value),
        lastModifiedDate.map(value => value),
        lastUpdatedBy.map(value => value),
        roleArn
      )
    def applicationId: __string
    def destinationStreamArn: __string
    def externalId: Option[__string]
    def lastModifiedDate: Option[__string]
    def lastUpdatedBy: Option[__string]
    def roleArn: __string
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getDestinationStreamArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(destinationStreamArn)
    def getExternalId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getLastModifiedDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLastUpdatedBy: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastUpdatedBy", lastUpdatedBy)
    def getRoleArn: ZIO[Any, Nothing, __string] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EventStream
  ) extends zio.aws.pinpoint.model.EventStream.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val destinationStreamArn: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.destinationStreamArn())
    override val externalId: Option[__string] = scala
      .Option(impl.externalId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val lastModifiedDate: Option[__string] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val lastUpdatedBy: Option[__string] = scala
      .Option(impl.lastUpdatedBy())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val roleArn: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EventStream
  ): zio.aws.pinpoint.model.EventStream.ReadOnly = new Wrapper(impl)
}
