package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class EventsRequest(
    batchItem: Map[__string, zio.aws.pinpoint.model.EventsBatch]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EventsRequest = {
    import EventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EventsRequest
      .builder()
      .batchItem(
        batchItem
          .map({ case (key, value) =>
            (__string.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EventsRequest.ReadOnly =
    zio.aws.pinpoint.model.EventsRequest.wrap(buildAwsValue())
}
object EventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EventsRequest =
      zio.aws.pinpoint.model.EventsRequest(batchItem.map({ case (key, value) =>
        key -> value.asEditable
      }))
    def batchItem: Map[__string, zio.aws.pinpoint.model.EventsBatch.ReadOnly]
    def getBatchItem: ZIO[Any, Nothing, Map[
      __string,
      zio.aws.pinpoint.model.EventsBatch.ReadOnly
    ]] = ZIO.succeed(batchItem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EventsRequest
  ) extends zio.aws.pinpoint.model.EventsRequest.ReadOnly {
    override val batchItem
        : Map[__string, zio.aws.pinpoint.model.EventsBatch.ReadOnly] = impl
      .batchItem()
      .asScala
      .map({ case (key, value) =>
        zio.aws.pinpoint.model.primitives
          .__string(key) -> zio.aws.pinpoint.model.EventsBatch.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EventsRequest
  ): zio.aws.pinpoint.model.EventsRequest.ReadOnly = new Wrapper(impl)
}
