package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class EventsResponse(
    results: Option[Map[__string, zio.aws.pinpoint.model.ItemResponse]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EventsResponse = {
    import EventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EventsResponse
      .builder()
      .optionallyWith(
        results.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.results)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EventsResponse.ReadOnly =
    zio.aws.pinpoint.model.EventsResponse.wrap(buildAwsValue())
}
object EventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EventsResponse =
      zio.aws.pinpoint.model.EventsResponse(
        results.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def results
        : Option[Map[__string, zio.aws.pinpoint.model.ItemResponse.ReadOnly]]
    def getResults: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.ItemResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("results", results)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EventsResponse
  ) extends zio.aws.pinpoint.model.EventsResponse.ReadOnly {
    override val results
        : Option[Map[__string, zio.aws.pinpoint.model.ItemResponse.ReadOnly]] =
      scala
        .Option(impl.results())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.pinpoint.model.primitives.__string(
                key
              ) -> zio.aws.pinpoint.model.ItemResponse.wrap(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EventsResponse
  ): zio.aws.pinpoint.model.EventsResponse.ReadOnly = new Wrapper(impl)
}
