package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class ExportJobResource(
    roleArn: __string,
    s3UrlPrefix: __string,
    segmentId: Option[__string] = None,
    segmentVersion: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ExportJobResource = {
    import ExportJobResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ExportJobResource
      .builder()
      .roleArn(__string.unwrap(roleArn): java.lang.String)
      .s3UrlPrefix(__string.unwrap(s3UrlPrefix): java.lang.String)
      .optionallyWith(
        segmentId.map(value => __string.unwrap(value): java.lang.String)
      )(_.segmentId)
      .optionallyWith(
        segmentVersion.map(value => __integer.unwrap(value): Integer)
      )(_.segmentVersion)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ExportJobResource.ReadOnly =
    zio.aws.pinpoint.model.ExportJobResource.wrap(buildAwsValue())
}
object ExportJobResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ExportJobResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ExportJobResource =
      zio.aws.pinpoint.model.ExportJobResource(
        roleArn,
        s3UrlPrefix,
        segmentId.map(value => value),
        segmentVersion.map(value => value)
      )
    def roleArn: __string
    def s3UrlPrefix: __string
    def segmentId: Option[__string]
    def segmentVersion: Option[__integer]
    def getRoleArn: ZIO[Any, Nothing, __string] = ZIO.succeed(roleArn)
    def getS3UrlPrefix: ZIO[Any, Nothing, __string] = ZIO.succeed(s3UrlPrefix)
    def getSegmentId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("segmentId", segmentId)
    def getSegmentVersion: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("segmentVersion", segmentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ExportJobResource
  ) extends zio.aws.pinpoint.model.ExportJobResource.ReadOnly {
    override val roleArn: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.roleArn())
    override val s3UrlPrefix: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.s3UrlPrefix())
    override val segmentId: Option[__string] = scala
      .Option(impl.segmentId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val segmentVersion: Option[__integer] = scala
      .Option(impl.segmentVersion())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ExportJobResource
  ): zio.aws.pinpoint.model.ExportJobResource.ReadOnly = new Wrapper(impl)
}
