package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait FilterType {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.FilterType
}
object FilterType {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.FilterType
  ): zio.aws.pinpoint.model.FilterType = value match {
    case software.amazon.awssdk.services.pinpoint.model.FilterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.FilterType.SYSTEM =>
      val r = SYSTEM
      r
    case software.amazon.awssdk.services.pinpoint.model.FilterType.ENDPOINT =>
      val r = ENDPOINT
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.FilterType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.FilterType =
      software.amazon.awssdk.services.pinpoint.model.FilterType.UNKNOWN_TO_SDK_VERSION
  }
  case object SYSTEM extends zio.aws.pinpoint.model.FilterType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.FilterType =
      software.amazon.awssdk.services.pinpoint.model.FilterType.SYSTEM
  }
  case object ENDPOINT extends zio.aws.pinpoint.model.FilterType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.FilterType =
      software.amazon.awssdk.services.pinpoint.model.FilterType.ENDPOINT
  }
}
