package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__boolean, __string}
import scala.jdk.CollectionConverters.*
final case class GCMChannelRequest(
    apiKey: __string,
    enabled: Option[__boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GCMChannelRequest = {
    import GCMChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GCMChannelRequest
      .builder()
      .apiKey(__string.unwrap(apiKey): java.lang.String)
      .optionallyWith(
        enabled.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.GCMChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.GCMChannelRequest.wrap(buildAwsValue())
}
object GCMChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GCMChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GCMChannelRequest =
      zio.aws.pinpoint.model
        .GCMChannelRequest(apiKey, enabled.map(value => value))
    def apiKey: __string
    def enabled: Option[__boolean]
    def getApiKey: ZIO[Any, Nothing, __string] = ZIO.succeed(apiKey)
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GCMChannelRequest
  ) extends zio.aws.pinpoint.model.GCMChannelRequest.ReadOnly {
    override val apiKey: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.apiKey())
    override val enabled: Option[__boolean] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GCMChannelRequest
  ): zio.aws.pinpoint.model.GCMChannelRequest.ReadOnly = new Wrapper(impl)
}
