package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __boolean, __string}
import scala.jdk.CollectionConverters.*
final case class GCMMessage(
    action: Option[zio.aws.pinpoint.model.Action] = None,
    body: Option[__string] = None,
    collapseKey: Option[__string] = None,
    data: Option[Map[__string, __string]] = None,
    iconReference: Option[__string] = None,
    imageIconUrl: Option[__string] = None,
    imageUrl: Option[__string] = None,
    priority: Option[__string] = None,
    rawContent: Option[__string] = None,
    restrictedPackageName: Option[__string] = None,
    silentPush: Option[__boolean] = None,
    smallImageIconUrl: Option[__string] = None,
    sound: Option[__string] = None,
    substitutions: Option[Map[__string, Iterable[__string]]] = None,
    timeToLive: Option[__integer] = None,
    title: Option[__string] = None,
    url: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GCMMessage = {
    import GCMMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GCMMessage
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(
        body.map(value => __string.unwrap(value): java.lang.String)
      )(_.body)
      .optionallyWith(
        collapseKey.map(value => __string.unwrap(value): java.lang.String)
      )(_.collapseKey)
      .optionallyWith(
        data.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.data)
      .optionallyWith(
        iconReference.map(value => __string.unwrap(value): java.lang.String)
      )(_.iconReference)
      .optionallyWith(
        imageIconUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.imageIconUrl)
      .optionallyWith(
        imageUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.imageUrl)
      .optionallyWith(
        priority.map(value => __string.unwrap(value): java.lang.String)
      )(_.priority)
      .optionallyWith(
        rawContent.map(value => __string.unwrap(value): java.lang.String)
      )(_.rawContent)
      .optionallyWith(
        restrictedPackageName.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.restrictedPackageName)
      .optionallyWith(
        silentPush.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.silentPush)
      .optionallyWith(
        smallImageIconUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.smallImageIconUrl)
      .optionallyWith(
        sound.map(value => __string.unwrap(value): java.lang.String)
      )(_.sound)
      .optionallyWith(
        substitutions.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.map { item =>
                __string.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.substitutions)
      .optionallyWith(
        timeToLive.map(value => __integer.unwrap(value): Integer)
      )(_.timeToLive)
      .optionallyWith(
        title.map(value => __string.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        url.map(value => __string.unwrap(value): java.lang.String)
      )(_.url)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.GCMMessage.ReadOnly =
    zio.aws.pinpoint.model.GCMMessage.wrap(buildAwsValue())
}
object GCMMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GCMMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GCMMessage =
      zio.aws.pinpoint.model.GCMMessage(
        action.map(value => value),
        body.map(value => value),
        collapseKey.map(value => value),
        data.map(value => value),
        iconReference.map(value => value),
        imageIconUrl.map(value => value),
        imageUrl.map(value => value),
        priority.map(value => value),
        rawContent.map(value => value),
        restrictedPackageName.map(value => value),
        silentPush.map(value => value),
        smallImageIconUrl.map(value => value),
        sound.map(value => value),
        substitutions.map(value => value),
        timeToLive.map(value => value),
        title.map(value => value),
        url.map(value => value)
      )
    def action: Option[zio.aws.pinpoint.model.Action]
    def body: Option[__string]
    def collapseKey: Option[__string]
    def data: Option[Map[__string, __string]]
    def iconReference: Option[__string]
    def imageIconUrl: Option[__string]
    def imageUrl: Option[__string]
    def priority: Option[__string]
    def rawContent: Option[__string]
    def restrictedPackageName: Option[__string]
    def silentPush: Option[__boolean]
    def smallImageIconUrl: Option[__string]
    def sound: Option[__string]
    def substitutions: Option[Map[__string, List[__string]]]
    def timeToLive: Option[__integer]
    def title: Option[__string]
    def url: Option[__string]
    def getAction: ZIO[Any, AwsError, zio.aws.pinpoint.model.Action] =
      AwsError.unwrapOptionField("action", action)
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getCollapseKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("collapseKey", collapseKey)
    def getData: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("data", data)
    def getIconReference: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("iconReference", iconReference)
    def getImageIconUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("imageIconUrl", imageIconUrl)
    def getImageUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("imageUrl", imageUrl)
    def getPriority: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("priority", priority)
    def getRawContent: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("rawContent", rawContent)
    def getRestrictedPackageName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("restrictedPackageName", restrictedPackageName)
    def getSilentPush: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("silentPush", silentPush)
    def getSmallImageIconUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("smallImageIconUrl", smallImageIconUrl)
    def getSound: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sound", sound)
    def getSubstitutions: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("substitutions", substitutions)
    def getTimeToLive: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("timeToLive", timeToLive)
    def getTitle: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("title", title)
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GCMMessage
  ) extends zio.aws.pinpoint.model.GCMMessage.ReadOnly {
    override val action: Option[zio.aws.pinpoint.model.Action] = scala
      .Option(impl.action())
      .map(value => zio.aws.pinpoint.model.Action.wrap(value))
    override val body: Option[__string] = scala
      .Option(impl.body())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val collapseKey: Option[__string] = scala
      .Option(impl.collapseKey())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val data: Option[Map[__string, __string]] = scala
      .Option(impl.data())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val iconReference: Option[__string] = scala
      .Option(impl.iconReference())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val imageIconUrl: Option[__string] = scala
      .Option(impl.imageIconUrl())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val imageUrl: Option[__string] = scala
      .Option(impl.imageUrl())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val priority: Option[__string] = scala
      .Option(impl.priority())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val rawContent: Option[__string] = scala
      .Option(impl.rawContent())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val restrictedPackageName: Option[__string] = scala
      .Option(impl.restrictedPackageName())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val silentPush: Option[__boolean] = scala
      .Option(impl.silentPush())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val smallImageIconUrl: Option[__string] = scala
      .Option(impl.smallImageIconUrl())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val sound: Option[__string] = scala
      .Option(impl.sound())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val substitutions: Option[Map[__string, List[__string]]] = scala
      .Option(impl.substitutions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives
              .__string(key) -> value.asScala.map { item =>
              zio.aws.pinpoint.model.primitives.__string(item)
            }.toList
          })
          .toMap
      )
    override val timeToLive: Option[__integer] = scala
      .Option(impl.timeToLive())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val title: Option[__string] = scala
      .Option(impl.title())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val url: Option[__string] = scala
      .Option(impl.url())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GCMMessage
  ): zio.aws.pinpoint.model.GCMMessage.ReadOnly = new Wrapper(impl)
}
